package org.eclipse.hyades.logging.events;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;

import org.eclipse.hyades.logging.core.ISerializableAsXml;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AssociationEngineImpl.java,v 1.17 2005/02/16 22:20:41 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * This is the class that embodies the Association Engine as described in 
 * "Canonical Situation Data Format: The Common Base Event V1.0.1 
 * ACAB.BO0301.0.1"
 *
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public class AssociationEngineImpl implements IAssociationEngine, ISerializableAsXml, Serializable, Cloneable {

    //define the serialiVersionUID for serialization
    //if this object is ever changed that breaks backward compatability
    //this value MUST be changed Every effort should be made not to
    //break backward compatability
    static final long serialVersionUID = 4692191796038100840L;

    // define the fields that will be serialized. 
    // if any new variables are added to the class
    // this table should be updated along with the readObject and writeObject methods
    private static final ObjectStreamField[] serialPersistentFields = { new ObjectStreamField("id", String.class), new ObjectStreamField("name", String.class), new ObjectStreamField("type", String.class), };

    /**
     * Fields.
     */
    protected String id = null;
    protected String name = null;
    protected String type = null;

    protected AssociationEngineImpl() {
        super();
		id = (SimpleEventFactoryImpl.getInstance().createGlobalInstanceId());
    }

    /**
     * @see org.eclipse.hyades.logging.events.IAssociationEngine#getId()
     */
    public String getId() {
        return id;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IAssociationEngine#getName()
     */
    public String getName() {
        return name;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IAssociationEngine#getType()
     */
    public String getType() {
        return type;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IAssociationEngine#setId(String)
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IAssociationEngine#setName(String)
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IAssociationEngine#setType(String)
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * @see org.eclipse.hyades.logging.core.IExternalizableToXml#externalizeCanonicalXmlString()
     * @since 1.0
     * @deprecated Use org.eclipse.hyades.logging.events.CommonBaseEventImpl#externalizeCanonicalXmlString() as of 1.0.1.
     */
    public String externalizeCanonicalXmlString() {
        return CbeFormatter.toCanonicalXMLString(this);
    }

    /**
     * @see org.eclipse.hyades.logging.core.IExternalizableToXml#externalizeCanonicalXmlDocString()
     * @since 1.0
     * @deprecated Use org.eclipse.hyades.logging.events.CommonBaseEventImpl#externalizeCanonicalXmlDocString() as of 1.0.1.
     */
    public String externalizeCanonicalXmlDocString() {
        return CbeFormatter.toCanonicalXMLDocString(this);
    }

    /**
     * @see org.eclipse.hyades.logging.core.IInternalizableFromXml#internalizeCanonicalXmlString(java.lang.String)
     * @since 1.0
     * @deprecated Use org.eclipse.hyades.logging.events.CommonBaseEventImpl#internalizeCanonicalXmlString(String) as of 1.0.1.
     */
    public void internalizeCanonicalXmlString(String value) {
        CbeFormatter.fromCanonicalXMLString(this, value);
        return;
    }

    /**
     * @see org.eclipse.hyades.logging.core.IInternalizableFromXml#internalizeCanonicalXmlDocString(java.lang.String)
     * @since 1.0
     * @deprecated Use org.eclipse.hyades.logging.events.CommonBaseEventImpl#internalizeCanonicalXmlDocString(String) as of 1.0.1.
     */
    public void internalizeCanonicalXmlDocString(String value) {
        CbeFormatter.fromCanonicalXMLDocString(this, value);
        return;
    }

    /**
     * Determines is two different objects are equal.
     */
    public boolean equals(Object obj) {
        boolean result = false;

        //It's the same object reference, so it HAS to be equal
        if (this == obj) {
            result = true;
        }
        else {
            //If the object is null or is not the correct type of object, it can't be
            //equal
            if ((obj != null) && (obj instanceof AssociationEngineImpl) && (getClass() == obj.getClass())) {
                AssociationEngineImpl associationEngine = (AssociationEngineImpl) obj;

                Object property1;
                Object property2;

                property1 = getId();
                property2 = associationEngine.getId();

                if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                    property1 = getType();
                    property2 = associationEngine.getType();

                    if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                        property1 = getName();
                        property2 = associationEngine.getName();

                        if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                            result = true;
                        }
                    }
                }
            }
        }

        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        // set the values of the Serializable fields
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("id", id);
        fields.put("name", name);
        fields.put("type", type);

        // save them
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        // prepare to read the alternate persistent fields
        ObjectInputStream.GetField fields = null;
        fields = in.readFields();

        // read the alternate persistent fields
        id = (String) fields.get("id", id);
        name = (String) fields.get("name", name);
        type = (String) fields.get("type", type);
    }

    /**
     * return a cloned (copy by value) object. This is a deep copy version, in which all the
     * objects within this object will be copied by value.
     *  
     * @return Object
     */
    public Object clone() throws CloneNotSupportedException {
        return (super.clone());
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * Initialize a AssociationEngine so that it has a new guid and all components 
     * are initialized to either zero or null
     * 
     * @see org.eclipse.hyades.logging.events.IAssociationEngine#init()
     * @since 1.0.1
     */
    public void init() {

        name = null;
        type = null;
        
		id = (SimpleEventFactoryImpl.getInstance().createGlobalInstanceId());
    }
}
