package org.eclipse.hyades.logging.events;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ComponentIdentificationImpl.java,v 1.12 2005/02/16 22:20:41 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Taken from "Canonical Situation Data Format: The Common Base Event V1.0.1 
 * ACAB.BO0301.0.1"
 * 
 * In problem reporting there are two general categories of components that should be
 * considered for problem diagnosis, the component observing and reporting the situation
 * (reporter), and the actual component that is experiencing the situation (affected).
 * Component Identification provides a collection of attributes required to uniquely 
 * identify a component.  The same data is used to identify both the component that is
 * reporting an event or situation and the component that is affected or experiencing the
 * situation.  In some cases, these components will be the same. For example, in a typical
 * IT environment, commonly, the activities of applications running in that environment 
 * are often monitored using events received or collected from the applications via 
 * management agents or adapters. 
 * 
 * Example 1: Consider the case where a WebSphere application, called myWebApp, times out
 *            on a table query due to a DB2 server problem that is located on a remote 
 *            system.  The web app then issues an event indicating the failure situation.
 *            In this case, myWebApp is the 'affected' or the 'source' component.
 * 
 * Example 2: Consider a case where there is application X running on a Windows server.
 *            The application encounters an error and adds an entry to the Widows error
 *            log. Then there is a separate application (ie: an adapter) that reads
 *            messages from the error log and generates a common base event and submits
 *            it. In this case the  'affected' or the 'source' of the event is the
 *            application X and the reporting component is the adapter that generated and
 *            submitted the event.
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0
 * @see IComponentIdentification
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public class ComponentIdentificationImpl implements IComponentIdentification, Serializable, Cloneable {

    //define the serialiVersionUID for serialization
    //if this object is ever changed that breaks backward compatability
    //this value MUST be changed Every effort should be made not to
    //break backward compatability
    static final long serialVersionUID = 5181834676140584153L;

    // define the fields that will be serialized. 
    // if any new variables are added to the class
    // this table should be updated along with the readObject and writeObject methods
    private static final ObjectStreamField[] serialPersistentFields = { new ObjectStreamField("location", String.class), new ObjectStreamField("locationType", String.class), new ObjectStreamField("application", String.class), new ObjectStreamField("executionEnvironment", String.class), new ObjectStreamField("component", String.class), new ObjectStreamField("subComponent", String.class), new ObjectStreamField("componentIdType", String.class), new ObjectStreamField("instanceId", String.class), new ObjectStreamField("processId", String.class), new ObjectStreamField("threadId", String.class), new ObjectStreamField("componentType", String.class)};

    /**
     * Fields.
     */
    protected String location = null;
    protected String locationType = null;
    protected String application = null;
    protected String executionEnvironment = null;
    protected String component = null;
    protected String subComponent = null;
    protected String componentIdType = null;
    protected String instanceId = null;
    protected String processId = null;
    protected String threadId = null;
    protected String componentType = null;

    /**
     * Constructor for ComponentIdentificationImpl.
     */
    protected ComponentIdentificationImpl() {
        super();
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#getApplication()
     */
    public String getApplication() {
        return application;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#getComponent()
     */
    public String getComponent() {
        return component;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#getExecutionEnvironment()
     */
    public String getExecutionEnvironment() {
        return executionEnvironment;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#getInstanceId()
     */
    public String getInstanceId() {
        return instanceId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#getLocation()
     */
    public String getLocation() {
        return location;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#getLocationType()
     */
    public String getLocationType() {
        return locationType;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#getProcessId()
     */
    public String getProcessId() {
        return processId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#getSubComponent()
     */
    public String getSubComponent() {
        return subComponent;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#getThreadId()
     */
    public String getThreadId() {
        return threadId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#getComponentIdType()
     */
    public String getComponentIdType() {
        return componentIdType;
    }

    /**
     * Returns the componentType.
     * 
     * The componentType is a well-defined name that is used to characterize all 
     * instances of a given kind of component.  
     * This property is REQUIRED property. 
     * The maximum string length for componentType MUST NOT exceed 512 characters.   
     * 
     * @return String The returned componentType.
     * @since 1.0.1
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#getComponentType()
     */
    public String getComponentType() {
        return componentType;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#setApplication(String)
     */
    public void setApplication(String application) {
        this.application = application;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#setComponent(String)
     */
    public void setComponent(String component) {
        this.component = component;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#setExecutionEnvironment(String)
     */
    public void setExecutionEnvironment(String executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#setInstanceId(String)
     */
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#setLocation(String)
     */
    public void setLocation(String location) {
        this.location = location;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#setLocationType(String)
     */
    public void setLocationType(String locationType) {
        this.locationType = locationType;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#setProcessId(String)
     */
    public void setProcessId(String processId) {
        this.processId = processId;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#setSubComponent(String)
     */
    public void setSubComponent(String subComponent) {
        this.subComponent = subComponent;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#setThreadId(String)
     */
    public void setThreadId(String threadId) {
        this.threadId = threadId;
    }

    /**
     * Sets the componentType.
     * 
     * The componentType is a well-defined name that is used to characterize all 
     * instances of a given kind of component.  
     * This property is REQUIRED property. 
     * The maximum string length for componentType MUST NOT exceed 512 characters.   
     * 
     * @param componentType The componentType to be set.
     * @since 1.0.1
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#setComponentType(String)
     */
    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    /**
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#setComponentIdType(String)
     */
    public void setComponentIdType(String componentIdType) {
        this.componentIdType = componentIdType;
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * @see org.eclipse.hyades.logging.events.IComponentIdentification#init()
     */
    public void init() {
        location = null;
        locationType = null;
        application = null;
        executionEnvironment = null;
        component = null;
        subComponent = null;
        componentIdType = null;
        instanceId = null;
        processId = null;
        threadId = null;
        componentType = null;
    }

    /**
     * Determines is two different objects are equal.
     */
    public boolean equals(Object obj) {
        boolean result = false;

        //It's the same object reference, so it HAS to be equal
        if (this == obj) {
            result = true;
        }
        else {
            //If the object is null or is not the correct type of object, it can't be
            //equal
            if ((obj != null) && (obj instanceof ComponentIdentificationImpl) && (getClass() == obj.getClass())) {
                ComponentIdentificationImpl componentIdentification = (ComponentIdentificationImpl) obj;

                Object property1;
                Object property2;

                property1 = getLocation();
                property2 = componentIdentification.getLocation();

                if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                    property1 = getLocationType();
                    property2 = componentIdentification.getLocationType();

                    if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                        property1 = getApplication();
                        property2 = componentIdentification.getApplication();

                        if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                            property1 = getExecutionEnvironment();
                            property2 = componentIdentification.getExecutionEnvironment();

                            if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                                property1 = getComponent();
                                property2 = componentIdentification.getComponent();

                                if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                                    property1 = getSubComponent();
                                    property2 = componentIdentification.getSubComponent();

                                    if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                                        property1 = getComponentIdType();
                                        property2 = componentIdentification.getComponentIdType();

                                        if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                                            property1 = getInstanceId();
                                            property2 = componentIdentification.getInstanceId();

                                            if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                                                property1 = getProcessId();
                                                property2 = componentIdentification.getProcessId();

                                                if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                                                    property1 = getThreadId();
                                                    property2 = componentIdentification.getThreadId();

                                                    if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {

                                                        property1 = getComponentType();
                                                        property2 = componentIdentification.getComponentType();

                                                        if (((property1 != null) && (property1.equals(property2))) || ((property1 == null) && (property2 == null))) {
                                                            result = true;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        // set the values of the Serializable fields
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("location", location);
        fields.put("locationType", locationType);
        fields.put("application", application);
        fields.put("executionEnvironment", executionEnvironment);
        fields.put("component", component);
        fields.put("subComponent", subComponent);
        fields.put("componentIdType", componentIdType);
        fields.put("instanceId", instanceId);
        fields.put("processId", processId);
		fields.put("threadId", threadId);
		fields.put("componentType", componentType);

        // save them
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        // prepare to read the alternate persistent fields
        ObjectInputStream.GetField fields = null;
        fields = in.readFields();

        // read the alternate persistent fields
        location = (String) fields.get("location", location);
        locationType = (String) fields.get("locationType", locationType);
        application = (String) fields.get("application", application);
        executionEnvironment = (String) fields.get("executionEnvironment", executionEnvironment);
        component = (String) fields.get("component", component);
        subComponent = (String) fields.get("subComponent", subComponent);
        componentIdType = (String) fields.get("componentIdType", componentIdType);
        instanceId = (String) fields.get("instanceId", instanceId);
        processId = (String) fields.get("processId", processId);
		threadId = (String) fields.get("threadId", threadId);
		componentType = (String) fields.get("componentType", componentType);
    }

    /**
     * return a cloned (copy by value) object. This is a deep copy version, in which all the
     * objects within this object will be copied by value.
     *  
     * @return Object
     */
    public Object clone() throws CloneNotSupportedException {
        return (super.clone());
    }

}
