package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IAssociatedEvent.java,v 1.10 2005/02/16 22:20:48 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Taken from "Canonical Situation Data Format: The Common Base Event V1.0.1 
 * ACAB.BO0301.0.1"
 *
 * The AssociatedEvent type allows for associated events to be grouped.  It allows for 
 * identifying associated events and its associationEngine.  The associationEngine MAY 
 * be the reference to the application that created the association.
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public interface IAssociatedEvent {

    /**
     * Adds a Common Base Event reference to the array of resolved events.
     * 
     * Array of Common Base Event globalInstanceIds corresponding to the event(s) that 
     * are associated with this event.
     * This is a REQUIRED property.
     * 
     * @param globalInstanceId The new Common Base Event globalInstanceId.
     * @see ICommonBaseEvent
     * @since 1.0
     */
    public void addResolvedEvent(String globalInstanceId);

    /**
     * Sets a space delimited list of Common Base Event references to the array of resolved events.
     * 
     * Array of Common Base Event globalInstanceIds corresponding to the event(s) that 
     * are associated with this event.
     * This is a REQUIRED property.
     * 
     * @param value The new space delimited list of Common Base Event references.
     * @see ICommonBaseEvent
     * @since 1.0.1
     */
    public void setResolvedEvents(String value);

    /**
     * Sets an array of Common Base Event references to the array of resolved events.
     * 
     * Array of Common Base Event globalInstanceIds corresponding to the event(s) that 
     * are associated with this event.
     * This is a REQUIRED property.
     * 
     * @param value The new array of Common Base Event references.
     * @see ICommonBaseEvent
     * @since 1.0.1
     */
    public void setResolvedEventsAsArray(String[] value);

    /**
     * Returned a space delimited string of Common Base Event references of resolved events.
     * 
     * Space delimited string of Common Base Event globalInstanceIds corresponding to the 
     * event(s) that are associated with this event.
     * This is a REQUIRED property.
     * 
     * @return Space delimited string of Common Base Event references of resolved events.
     * @see ICommonBaseEvent
     * @since 1.0.1
     */
    public String getResolvedEvents();

    /**
     * Returned an array of Common Base Event references of resolved events.
     * 
     * Array of Common Base Event globalInstanceIds corresponding to the event(s) that 
     * are associated with this event.
     * This is a REQUIRED property.
     * 
     * @return String array of Common Base Event references of resolved events.
     * @see ICommonBaseEvent
     * @since 1.0
     */
    public String[] getResolvedEventsAsArray();

    /**
     * Removes all Common Base Event references in the array of resolved events.
     * 
     * Array of Common Base Event globalInstanceIds corresponding to the event(s) that 
     * are associated with this event.
     * This is a REQUIRED property.
     * 
     * @see ICommonBaseEvent
     * @since 1.0
     */
    public void clearResolvedEvents();

    /**
     * Removes a named Common Base Event reference in the array of resolved events.
     * 
     * Array of Common Base Event globalInstanceIds corresponding to the event(s) that 
     * are associated with this event.
     * This is a REQUIRED property.
     * 
     * @param globalInstanceId The removed Common Base Event globalInstanceId.
     * @see ICommonBaseEvent
     * @since 1.0
     */
    public void removeResolvedEvent(String globalInstanceId);

    /**
     * Sets the assocationEngine.
     * 
     * Identifies the application that establishes association among related or 
     * associated events.  In addition, it provides properties to describe the 
     * type of the association.  The associationEngine and associationEnginInfo 
     * properties are mutually exclusive.  One of these properties MUST be defined.
     * 
     * @param name The assocationEngine to be set.
     * @see IAssociationEngine
     * @since 1.0
     */
    public void setAssociationEngine(String associationEngine);

    /**
     * Returns the associationEngine.
     * 
     * Reference to the AssocationEngine that created this AssociatedEvent.
     * The associationEngine and associationEnginInfo properties are mutually 
     * exclusive.  One of these properties MUST be defined.
     * 
     * @return String The returned associationEngine.
     * @see IAssociationEngine
     * @since 1.0
     */
    public String getAssociationEngine();

    /**
     * Sets the associationEngineInfo.
     * 
     * Identifies the application that establishes association among related or 
     * associated events.  In addition, it provides properties to describe the 
     * type of the association.  The associationEngine and associationEnginInfo 
     * properties are mutually exclusive.  One of these properties MUST be defined.
     * 
     * @param name The associationEngineInfo to be set.
     * @see IAssociationEngine
     * @since 1.0
     */
    public void setAssociationEngineInfo(IAssociationEngine associationEngineInfo);

    /**
     * Sets the associationEngineInfo.
     * 
     * Identifies the application that establishes association among related or 
     * associated events.  In addition, it provides properties to describe the 
     * type of the association.  The associationEngine and associationEnginInfo 
     * properties are mutually exclusive.  One of these properties MUST be defined.
     * 
     * @param name The associationEngineInfo to be set.
     * @see IAssociationEngine
     * @since 1.0.1
     */
    public void setAssociationEngineInfo(String associationEngineName, String associationEngineType, String associationEngineId);

    /**
     * Returns the associationEngineInfo.
     * 
     * Identifies the application that establishes association among related or 
     * associated events.  In addition, it provides properties to describe the 
     * type of the association.  The associationEngine and associationEnginInfo 
     * properties are mutually exclusive.  One of these properties MUST be defined.
     * 
     * @return IAssociationEngine The returned associationEngineInfo.
     * @see IAssociationEngine
     * @since 1.0
     */
    public IAssociationEngine getAssociationEngineInfo();

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * @since 1.0
     */
    public void init();
}
