package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IAvailableSituation.java,v 1.5 2005/02/16 22:20:48 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * The AvailableSituation deals with the situations reported from the component, 
 * regarding its operational state and availability. This situation provides a 
 * context for operations that can be performed on the component by distinguishing 
 * if a product is installed, operational and ready to process functional requests, 
 * or operational and ready/not ready to process management requests. Existing message 
 * include words like those that now ready to take requests, online, and offline, for 
 * example:
 * 
 * <code>
 * ADMC0013I: SOAP connector available at port 8880
 * ADMC0026I: RMI Connector available at port 2809
 * </code>
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @see ISituationType
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public interface IAvailableSituation extends ISituationType {

    /**
     * Returns the operationDisposition.
     * 
     * This property specifies the operation state of the component reported 
     * by the situation. The operationalDisposition is a string with the 
     * following set of values:
     * 
     * STARTABLE
     * NONSTARTABLE
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @return String The returned operationDisposition.
     * @since 1.0.1
     */
    public String getOperationDisposition();

	/**
	 * Returns the processingDisposition.
	 * 
	 * This property specifies the processing disposition of a component 
	 * opertation that caused the situation to be reported.  The 
	 * processingDisposition is a string with the following set of values:
	 * 
	 * FUNCTION_PROCESS
	 * FUNCTION_BLOCK
	 * MGMTTASK_PROCESS
	 * MGMTTASK_BLOCKED
	 * 
	 * This is a REQUIRED property and once it is set it MUST NOT change. 
	 * The string length for this property MUST NOT exceed 64 characters.
	 * 
	 * @return String The returned processingDisposition.
	 * @since 1.0.1
	 */
	public String getProcessingDisposition();

	/**
	 * Returns the availabilityDisposition.
	 * 
	 * This property specifies the availability disposition of an entity or 
	 * component that caused the situation to be reported.  The availableDisposition 
	 * is a string with the following set of values:
	 * 
	 * AVAILABLE
	 * NOT AVAILABLE
	 * 
	 * This is a REQUIRED property and once it is set it MUST NOT change. 
	 * The string length for this property MUST NOT exceed 64 characters.
	 * 
	 * @return String The returned availabilityDisposition.
	 * @since 1.0.1
	 */
	public String getAvailabilityDisposition();

    /**
     * Sets the operationDisposition.
     * 
     * This property specifies the operation state of the component reported 
     * by the situation. The operationalDisposition is a string with the 
     * following set of values:
     * 
     * STARTABLE
     * NONSTARTABLE
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @param operationDisposition The operationDisposition to be set.
     * @since 1.0.1
     */
    public void setOperationDisposition(String operationDisposition);

	/**
	 * Sets the processingDisposition.
	 * 
	 * This property specifies the processing disposition of a component 
	 * opertation that caused the situation to be reported.  The 
	 * processingDisposition is a string with the following set of values:
	 * 
	 * FUNCTION_PROCESS
	 * FUNCTION_BLOCK
	 * MGMTTASK_PROCESS
	 * MGMTTASK_BLOCKED
	 * 
	 * This is a REQUIRED property and once it is set it MUST NOT change. 
	 * The string length for this property MUST NOT exceed 64 characters.
	 * 
	 * @param processingDisposition The processingDisposition to be set.
	 * @since 1.0.1
	 */
	public void setProcessingDisposition(String processingDisposition);

	/**
	 * Sets the availabilityDisposition.
	 * 
	 * This property specifies the availability disposition of an entity or 
	 * component that caused the situation to be reported.  The availableDisposition 
	 * is a string with the following set of values:
	 * 
	 * AVAILABLE
	 * NOT AVAILABLE
	 * 
	 * This is a REQUIRED property and once it is set it MUST NOT change. 
	 * The string length for this property MUST NOT exceed 64 characters.
	 * 
	 * @param availabilityDisposition The availabilityDisposition to be set.
	 * @since 1.0.1
	 */
	public void setAvailabilityDisposition(String availabilityDisposition);
}
