package org.eclipse.hyades.logging.events;

import java.util.Date;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IEventFactory.java,v 1.6 2005/02/16 22:20:48 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Common iterface for all factories which construct Hyades logging event objects.
 * 
 * @version 1.0.1
 * @since 1.0
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public interface IEventFactory {

    /** A special value for event creation time, to indicate that the
     *  current system time is being specified in an API call.
     */
    public long CURRENT_TIME = Long.MIN_VALUE + 1;

    /** A special value for event severity, to indicate that no value
     * (as opposed to any default value) is being specified in an API call.
     */
    public short UNSPECIFIED_SEVERITY = Short.MIN_VALUE + 1;

    /** A special value for event priority, to indicate that no value
     * (as opposed to any default value) is being specified in an API call.
     */
    public short UNSPECIFIED_PRIORITY = Short.MIN_VALUE + 1;

    /** A special value for event repeat count, to indicate that no value
     * (as opposed to any default value) is being specified in an API call.
     */
    public short UNSPECIFIED_REPEAT_COUNT = Short.MIN_VALUE + 1;

    /** A special value for event elapsed time, to indicate that no value
     * (as opposed to any default value) is being specified in an API call.
     */
    public long UNSPECIFIED_ELAPSED_TIME = Long.MIN_VALUE + 1;

    /** A special value for event sequence number, to indicate that no value
     * (as opposed to any default value) is being specified in an API call.
     */
    public long UNSPECIFIED_SEQUENCE_NUM = Long.MIN_VALUE + 1;

    /**	Get the name of this factory instance.
     *	Instance names are immutable once set.
     *
     *	@return	The instance name.
     **/
    public String getName();

    /**	Get the fully-qualified interface name for the events
     *  created by this factory. This should either be:
     *	<code>org.eclipse.hyades.logging.events.ICommonBaseEvent</code>
     *	or an interface which extends it.
     *
     *	@return	The interface name.
     **/
    public String getEventInterfaceClassName();

    /**	Get the optional event settings for this factory
     *	instance. The values of this object (if any) will
     *  be used as defaults when creating new events.
     * 
     *	@return	The current event settings, or
     *				<code>null</code>	if no settings
     *				have been defined.
     **/
    public ICommonBaseEvent getEventSettings();

    /**	Set the optional event settings for this factory
     *	instance. The values of this object (if any) will
     *  be used as defaults when creating new events.
     * 
     *  <p>The settings object should be an event which was
     *  created by this factory's <code>createEmptyEvent()</code>
     *  method, then populated with values.</p>
     *
     *	@param	The new event settings, or <code>null</code>
     *			if no event settings should be used.
     **/
    public void setEventSettings(ICommonBaseEvent settings);

    /**	Create a new event.
     * 
     *	@param creationTime	The creation time for the event,
     *							or <code>null</code> to use the
     *							current system time.
     *
     *	@param sourceCompId	The source component ID for the event,
     *							or <code>null</code> to copy the value
     *							from the event settings.
     *
     *	<p>If event settings are defined for this factory instance,
     *	they will be used to set any fields not specified above.</p>
     *
     *	<p>NOTE: If the source component ID is not specified and is
     *	not found in the factory event settings, the event will not
     *	be created. Use <code>createEmptyEvent()</code> to create an
     *	event with no creation time or source component ID.</p>
     *
     *	@return	The new event, or <code>null</code> if no value
     *				was found for the required source component ID.
     *
     *	<p>The new event will implement the interface reported by
     *	   <code>getEventInterfaceClassName()</code>.</p>
     **/
    public ICommonBaseEvent createEvent(Date creationTime, IComponentIdentification sourceCompId);

    /**	Create a new event.
     * 
     *	@param creationTime	The creation time for the event, or
     * 							<code>CURRENT_TIME</code> to use the
     *							current system time.
     *
     *	@param sourceCompId	The source component ID for the event,
     *							or <code>null</code> to copy the value
     *							from the event settings.
     *
     *	<p>If event settings are defined for this factory instance,
     *	they will be used to set any fields not specified above.</p>
     *
     *	<p>NOTE: If the source component ID is not specified and is
     *	not found in the factory event settings, the event will not
     *	be created. Use <code>createEmptyEvent()</code> to create an
     *	event with no creation time or source component ID.</p>
     *
     *	@return	The new event, or <code>null</code> if no value
     *				was found for the required source component ID.
     *
     *	<p>The new event will implement the interface reported by
     *	   <code>getEventInterfaceClassName()</code>.</p>
     **/
    public ICommonBaseEvent createEvent(long creationTime, IComponentIdentification sourceCompId);

    /**	Create a new event.
      * 
      *	@param creationTime	The creation time for the event,
      *							or <code>null</code> to use the
      *							current system time.
      *
      *	@param localInstId		An optional local-instance identifier,
      *							or <code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param globalInstId	An optional global-instance identifier,
      *							or <code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param severity		The optional event severity, or
      *							<code>UNSPECIFIED_SEVERITY</code> to copy
      *							the value (if any) from the event settings.
      *
      *	@param priority		The optional event priority, or
      *							<code>UNSPECIFIED_PRIORITY</code> to copy 
      *							the value (if any) from the event settings
      *
      *	@param reporterCompId	The optional reporter component ID for
      *							the event, or <code>null</code> to copy
      *							the value (if any) from event settings.
      *
      *	@param sourceCompId	The required source component ID for
      *							the event, or <code>null</code> to copy
      *							the value from the event settings.
      *
      *	<p>NOTE: If the source component ID is not specified and is
      *	not found in the factory event settings, the event will not
      *	be created. Use <code>createEmptyEvent()</code> to create an
      *	event with no creation time or source component ID.</p>
      *
      *	@param situationType	An optional situation-type string,
      *							or <code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param contextData		An optional array of context data
      *							elements, or <code>null</code> to
      *							copy the value (if any) from the
      *							event settings.
      *
      *	@param msgData			Optional data about the message, or
      *							<code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param msg				The optional message text, or
      *							<code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param repeatCount		The optional repeat count, or
      *							<code>UNSPECIFIED_REPEAT_COUNT</code>
      *							to copy	the value (if any) from the
      *							event settings.
      *
      *	@param elapsedTime		The optional time (in microseconds)
      *							for the number of events specified
      *							in the repeat count, or 
      *							<code>UNSPECIFIED_ELAPSED_TIME</code>
      *							to copy	the value (if any) from the
      *							event settings.
      *
      *	@param assocEvents		An optional array of associated events,
      *							or <code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param extensionName	An optional extension name, or
      *							<code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param extendedData	An optional array of extended data
      *							elements, or <code>null</code> to
      *							copy the value (if any) from the
      *							event settings.
      *
      *	@param sequenceNum		An optional sequence number for the event,
      *							or <code>UNSPECIFIED_SEQUENCE_NUM</code>
      *							to copy the value (if any) from the
      *							event settings.
      *
      *	<p>If event settings are defined for this factory instance,
      *	they will be used to set any fields not specified above.</p>
      *
      *	@return	The new event, or <code>null</code> if no value
      *				was found for the required source component ID.
      *
      *	<p>The new event will implement the interface reported by
      *	   <code>getEventInterfaceClassName()</code>.</p>
      * @deprecated Use the createEvent(Date, String, String, short, short, IComponentIdentification, IComponentIdentification, ISituation, IContextDataElement[], IMsgDataElement, String, short, long, IAssociatedEvent, String, IExtendedDataElement, long,String[]) as of 1.0.1.
      **/
    public ICommonBaseEvent createEvent(Date creationTime, String localInstId, String globalInstId, short severity, short priority, IComponentIdentification reporterCompId, IComponentIdentification sourceCompId, String situationType, IContextDataElement contextData[], IMsgDataElement msgData, String msg, short repeatCount, long elapsedTime, IAssociatedEvent assocEvents[], String extensionName, IExtendedDataElement extendedData[], long sequenceNum);

    /**	Create a new event.
      * 
      *	@param creationTime	The creation time for the event, or
      * 						<code>CURRENT_TIME</code> to use the
      *							current system time.
      *
      *	@param localInstId		An optional local-instance identifier,
      *							or <code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param globalInstId	An optional global-instance identifier,
      *							or <code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param severity		The optional event severity, or
      *							<code>UNSPECIFIED_SEVERITY</code> to copy
      *							the value (if any) from the event settings.
      *
      *	@param priority		The optional event priority, or
      *							<code>UNSPECIFIED_PRIORITY</code> to copy 
      *							the value (if any) from the event settings
      *
      *	@param reporterCompId	The optional reporter component ID for
      *							the event, or <code>null</code> to copy
      *							the value (if any) from event settings.
      *
      *	@param sourceCompId	The required source component ID for
      *							the event, or <code>null</code> to copy
      *							the value from the event settings.
      *
      *	<p>NOTE: If the source component ID is not specified and is
      *	not found in the factory event settings, the event will not
      *	be created. Use <code>createEmptyEvent()</code> to create an
      *	event with no creation time or source component ID.</p>
      *
      *	@param situation    	A required ISituation or <code>null</code> 
      *                         to copy the value from the event settings.
      *
      *	@param contextData		An optional array of context data
      *							elements, or <code>null</code> to
      *							copy the value (if any) from the
      *							event settings.
      *
      *	@param msgData			Optional data about the message, or
      *							<code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param msg				The optional message text, or
      *							<code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param repeatCount		The optional repeat count, or
      *							<code>UNSPECIFIED_REPEAT_COUNT</code>
      *							to copy	the value (if any) from the
      *							event settings.
      *
      *	@param elapsedTime		The optional time (in microseconds)
      *							for the number of events specified
      *							in the repeat count, or 
      *							<code>UNSPECIFIED_ELAPSED_TIME</code>
      *							to copy	the value (if any) from the
      *							event settings.
      *
      *	@param assocEvents		An optional array of associated events,
      *							
      *
      *	@param extensionName	An optional extension name, or
      *							<code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param extendedData	    An optional array of extended data
      *							elements, or <code>null</code> to
      *							copy the value (if any) from the
      *							event settings.
      *
      *	@param sequenceNum		An optional sequence number for the event,
      *							or <code>UNSPECIFIED_SEQUENCE_NUM</code>
      *							to copy the value (if any) from the
      *							event settings.
      *
      *	@param otherData		An optional string array of other data
      *                         or <code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	<p>If event settings are defined for this factory instance,
      *	they will be used to set any fields not specified above.</p>
      *
      *	@return	The new event, or <code>null</code> if no value
      *				was found for the required source component ID.
      *
      *	<p>The new event will implement the interface reported by
      *	   <code>getEventInterfaceClassName()</code>.</p>
      * @since 1.0.1
      **/
    public ICommonBaseEvent createEvent(Date creationTime, String localInstId, String globalInstId, short severity, short priority, IComponentIdentification reporterCompId, IComponentIdentification sourceCompId, ISituation situation, IContextDataElement contextData[], IMsgDataElement msgData, String msg, short repeatCount, long elapsedTime, IAssociatedEvent assocEvents[], String extensionName, IExtendedDataElement extendedData[], long sequenceNum, String[] otherData);

    /**	Create a new event.
      * 
      *	@param creationTime	The creation time for the event, or
      * 						<code>CURRENT_TIME</code> to use the
      *							current system time.
      *
      *	@param localInstId		An optional local-instance identifier,
      *							or <code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param globalInstId	An optional global-instance identifier,
      *							or <code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param severity		The optional event severity, or
      *							<code>UNSPECIFIED_SEVERITY</code> to copy
      *							the value (if any) from the event settings.
      *
      *	@param priority		The optional event priority, or
      *							<code>UNSPECIFIED_PRIORITY</code> to copy 
      *							the value (if any) from the event settings
      *
      *	@param reporterCompId	The optional reporter component ID for
      *							the event, or <code>null</code> to copy
      *							the value (if any) from event settings.
      *
      *	@param sourceCompId	The required source component ID for
      *							the event, or <code>null</code> to copy
      *							the value from the event settings.
      *
      *	<p>NOTE: If the source component ID is not specified and is
      *	not found in the factory event settings, the event will not
      *	be created. Use <code>createEmptyEvent()</code> to create an
      *	event with no creation time or source component ID.</p>
      *
      *	@param situationType	An optional situation-type string,
      *							or <code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param contextData		An optional array of context data
      *							elements, or <code>null</code> to
      *							copy the value (if any) from the
      *							event settings.
      *
      *	@param msgData			Optional data about the message, or
      *							<code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param msg				The optional message text, or
      *							<code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param repeatCount		The optional repeat count, or
      *							<code>UNSPECIFIED_REPEAT_COUNT</code>
      *							to copy	the value (if any) from the
      *							event settings.
      *
      *	@param elapsedTime		The optional time (in microseconds)
      *							for the number of events specified
      *							in the repeat count, or 
      *							<code>UNSPECIFIED_ELAPSED_TIME</code>
      *							to copy	the value (if any) from the
      *							event settings.
      *
      *	@param assocEvents		An optional array of associated events,
      *							or <code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param extensionName	An optional extension name, or
      *							<code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param extendedData	An optional array of extended data
      *							elements, or <code>null</code> to
      *							copy the value (if any) from the
      *							event settings.
      *
      *	@param sequenceNum		An optional sequence number for the event,
      *							or <code>UNSPECIFIED_SEQUENCE_NUM</code>
      *							to copy the value (if any) from the
      *							event settings.
      *
      *	<p>If event settings are defined for this factory instance,
      *	they will be used to set any fields not specified above.</p>
      *
      *	@return	The new event, or <code>null</code> if no value
      *				was found for the required source component ID.
      *
      *	<p>The new event will implement the interface reported by
      *	   <code>getEventInterfaceClassName()</code>.</p>
      * @deprecated Use the createEvent(long, String, String, short, short, IComponentIdentification, IComponentIdentification, ISituation, IContextDataElement[], IMsgDataElement, String, short, long, IAssociatedEvent, String, IExtendedDataElement, long,String[]) as of 1.0.1.
      **/
    public ICommonBaseEvent createEvent(long creationTime, String localInstId, String globalInstId, short severity, short priority, IComponentIdentification reporterCompId, IComponentIdentification sourceCompId, String situationType, IContextDataElement contextData[], IMsgDataElement msgData, String msg, short repeatCount, long elapsedTime, IAssociatedEvent assocEvents[], String extensionName, IExtendedDataElement extendedData[], long sequenceNum);

    /**	Create a new event.
      * 
      *	@param creationTime	The creation time for the event, or
      * 						<code>CURRENT_TIME</code> to use the
      *							current system time.
      *
      *	@param localInstId		An optional local-instance identifier,
      *							or <code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param globalInstId	An optional global-instance identifier,
      *							or <code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param severity		The optional event severity, or
      *							<code>UNSPECIFIED_SEVERITY</code> to copy
      *							the value (if any) from the event settings.
      *
      *	@param priority		The optional event priority, or
      *							<code>UNSPECIFIED_PRIORITY</code> to copy 
      *							the value (if any) from the event settings
      *
      *	@param reporterCompId	The optional reporter component ID for
      *							the event, or <code>null</code> to copy
      *							the value (if any) from event settings.
      *
      *	@param sourceCompId	The required source component ID for
      *							the event, or <code>null</code> to copy
      *							the value from the event settings.
      *
      *	<p>NOTE: If the source component ID is not specified and is
      *	not found in the factory event settings, the event will not
      *	be created. Use <code>createEmptyEvent()</code> to create an
      *	event with no creation time or source component ID.</p>
      *
      *	@param situation    	A required ISituation or <code>null</code> 
      *                         to copy the value from the event settings.
      *
      *	@param contextData		An optional array of context data
      *							elements, or <code>null</code> to
      *							copy the value (if any) from the
      *							event settings.
      *
      *	@param msgData			Optional data about the message, or
      *							<code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param msg				The optional message text, or
      *							<code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param repeatCount		The optional repeat count, or
      *							<code>UNSPECIFIED_REPEAT_COUNT</code>
      *							to copy	the value (if any) from the
      *							event settings.
      *
      *	@param elapsedTime		The optional time (in microseconds)
      *							for the number of events specified
      *							in the repeat count, or 
      *							<code>UNSPECIFIED_ELAPSED_TIME</code>
      *							to copy	the value (if any) from the
      *							event settings.
      *
      *	@param assocEvents		An optional array of associated events,
      *							
      *
      *	@param extensionName	An optional extension name, or
      *							<code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	@param extendedData	    An optional array of extended data
      *							elements, or <code>null</code> to
      *							copy the value (if any) from the
      *							event settings.
      *
      *	@param sequenceNum		An optional sequence number for the event,
      *							or <code>UNSPECIFIED_SEQUENCE_NUM</code>
      *							to copy the value (if any) from the
      *							event settings.
      *
      *	@param otherData		An optional string array of other data
      *                         or <code>null</code> to copy the value
      *							(if any) from the event settings.
      *
      *	<p>If event settings are defined for this factory instance,
      *	they will be used to set any fields not specified above.</p>
      *
      *	@return	The new event, or <code>null</code> if no value
      *				was found for the required source component ID.
      *
      *	<p>The new event will implement the interface reported by
      *	   <code>getEventInterfaceClassName()</code>.</p>
      * @since 1.0.1
      **/
    public ICommonBaseEvent createEvent(long creationTime, String localInstId, String globalInstId, short severity, short priority, IComponentIdentification reporterCompId, IComponentIdentification sourceCompId, ISituation situation, IContextDataElement contextData[], IMsgDataElement msgData, String msg, short repeatCount, long elapsedTime, IAssociatedEvent assocEvents[], String extensionName, IExtendedDataElement extendedData[], long sequenceNum, String[] otherData);

    /**	Create an empty event.
     *
     *	<p>No fields will be set for this event. Any event settings
     *	for this factory instance will be ignored.</p>
     *
     *	@return	The empty new event.
     *
     *	<p>The new event will implement the interface reported by
     *	   <code>getEventInterfaceClassName()</code>.</p>
     **/
    public ICommonBaseEvent createEmptyEvent();

    /**	Initialization method. This should not be called by
     *	applications, and has no effect after this factory
     *	instance is initialized.
     *
     *	@param	The new name of this factory instance.
     **/
    public void init(String name);
}
