package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IFeatureSituation.java,v 1.4 2005/02/16 22:20:48 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * The FeatureSituation deals with the situations that announce that a feature 
 * of a component is now ready (or not ready) for service requests. Situations 
 * that indicate things like services being available and services or features 
 * being unavailable fall into this category. Existing situations include words 
 * like now available, currently available, and transport is listening on port 
 * 123, for example:
 * 
 * <code>
 * SRVE0171I: Transport HTTPS is listening on port 9443
 * MSGS0601I: WebSphere Embedded Messaging has not been installed
 * </code>
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @see ISituationType
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public interface IFeatureSituation extends ISituationType {

    /**
     * Returns the featureDisposition.
     * 
     * This property specifies the availability disposition of a feature 
     * of a component that caused the situation to be reported.
     * The featureDisposition is a string with the following set of values:
     * 
     * AVAILABLE
     * NOT AVAILABLE
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @return String The returned featureDisposition.
     * @since 1.0.1
     */
    public String getFeatureDisposition();

    /**
     * Sets the featureDisposition.
     * 
     * This property specifies the availability disposition of a feature 
     * of a component that caused the situation to be reported.
     * The featureDisposition is a string with the following set of values:
     * 
     * AVAILABLE
     * NOT AVAILABLE
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @param featureDisposition The featureDisposition to be set.
     * @since 1.0.1
     */
    public void setFeatureDisposition(String featureDisposition);
}
