package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IReportSituation.java,v 1.4 2005/02/16 22:20:48 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * The ReportSituation deals with the situations reported from the component, 
 * such as heartbeat or performance information. Data such as current CPU 
 * utilization, current memory heap size, etc. would fall into this category. 
 * Existing messages include words like utilization value is, buffer size is, 
 * and number of threads is, for example:
 * 
 * <code>
 * IEE890I WTO Buffers in console backup storage = 1024
 * </code>
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @see ISituationType
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public interface IReportSituation extends ISituationType {

    /**
     * Returns the reportCategory.
     * 
     * This property specifies the category of the reported situation. 
     * The reportCategory is a string with the following set of values:
     * 
     * PERFORMANCE
     * SECURITY
     * HEARTBEAT
     * STATUS
     * TRACE
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @return String The returned reportCategory.
     * @since 1.0.1
     */
    public String getReportCategory();

    /**
     * Sets the reportCategory.
     * 
     * This property specifies the category of the reported situation. 
     * The reportCategory is a string with the following set of values:
     * 
     * PERFORMANCE
     * SECURITY
     * HEARTBEAT
     * STATUS
     * TRACE
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @param reportCategory The reportCategory to be set.
     * @since 1.0.1
     */
    public void setReportCategory(String reportCategory);
}
