package org.eclipse.hyades.logging.events;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;

/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ReportSituationImpl.java,v 1.5 2005/02/16 22:20:48 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * The ReportSituation deals with the situations reported from the component, 
 * such as heartbeat or performance information. Data such as current CPU 
 * utilization, current memory heap size, etc. would fall into this category. 
 * Existing messages include words like utilization value is, buffer size is, 
 * and number of threads is, for example:
 * 
 * <code>
 * IEE890I WTO Buffers in console backup storage = 1024
 * </code>
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @see IReportSituation
 * @see ISituationType
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public class ReportSituationImpl extends SituationTypeImpl implements IReportSituation, Serializable, Cloneable {

    //Define the serialiVersionUID for serialization:
    //NOTE: If this object is ever changed which breaks backward compatibility,
    //this value MUST be changed.  Every effort should be made not to break 
    //backward compatibility.
    static final long serialVersionUID = -3888096669772662967L;

    //Define the fields that will be serialized: 
    //NOTE: If any new variables are added to the class this table should be 
    //updated along with the readObject and writeObject methods.
    private static final ObjectStreamField[] serialPersistentFields = { new ObjectStreamField("reportCategory", String.class)};

    //Class instance variable(s):
    protected String reportCategory = null;

    /**
     * No-argument protected constructor for ReportSituationImpl.
     */
    protected ReportSituationImpl() {
		super();
    }

    /**
     * Returns the reportCategory.
     * 
     * This property specifies the category of the reported situation. 
     * The reportCategory is a string with the following set of values:
     * 
     * PERFORMANCE
     * SECURITY
     * HEARTBEAT
     * STATUS
     * TRACE
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @return String The returned reportCategory.
     * @since 1.0.1
     */
    public String getReportCategory() {
        return reportCategory;
    }

    /**
     * Sets the reportCategory.
     * 
     * This property specifies the category of the reported situation. 
     * The reportCategory is a string with the following set of values:
     * 
     * PERFORMANCE
     * SECURITY
     * HEARTBEAT
     * STATUS
     * TRACE
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @param reportCategory The reportCategory to be set.
     * @since 1.0.1
     */
    public void setReportCategory(String reportCategory) {
        this.reportCategory = reportCategory;
    }

    /**
     * Overrides the <code>java.lang.Object</code>'s equals() API to 
     * determine if the parameter <code>object</code> is equal to this object.
     * 
     * @param object The <code>java.lang.Object</code> to be compared to this object.
     * @return true if this object is the same as the parameter <code>object</code>, false otherwise.
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object object) {

        //Check if the parameter object's super class is equal to the this object's super class:
        if (super.equals(object)) {

            //Compare the value(s) of all object properties:
            String thisObjectsProperty = getReportCategory();
            String parameterObjectsProperty = ((ReportSituationImpl) (object)).getReportCategory();

            if (((thisObjectsProperty != null) && (thisObjectsProperty.equals(parameterObjectsProperty))) || ((thisObjectsProperty == null) && (parameterObjectsProperty == null)))
                return true;
        }

        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {

        //Set the values of the serializable field(s):
        ObjectOutputStream.PutField fields = out.putFields();

        fields.put("reportCategory", reportCategory);

        //Write the values of the serializable field(s):
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {

        //Prepare and read the alternate persistent field(s):
        ObjectInputStream.GetField fields = null;

        fields = in.readFields();

        //Retrieve the alternate persistent field(s):
        reportCategory = ((String) (fields.get("reportCategory", reportCategory)));
    }

    /**
     * Return a clone (copy by value) of this object. This is a deep copy version, 
     * in which all the objects within this object will be copied by value.
     *  
     * @return Object The clone of this object.
     */
    public Object clone() throws CloneNotSupportedException {
        return (super.clone());
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * @see org.eclipse.hyades.logging.events.ISituationType#init()
     */
    public void init() {

        super.init();

        reportCategory = null;
    }
}