/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CannotCreateEventFactoryException.java,v 1.5 2005/02/16 22:20:48 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.events.exceptions;

/**
 * Exception to indicate that an event factory could not be created.
 * @deprecated This class is deprecated as of 2004-05-17
 */
public class CannotCreateEventFactoryException extends Exception
{

    /** A nested exception giving the detailed reason
     *  why the event factory could not be created.
     */
    private Exception reason = null;

    /**
     * Constructor for CannotCreateEventFactoryException.
     * 
     * @param ex	A nested exception which explains why
     * 				the event factory could not be created.
     */
    public CannotCreateEventFactoryException(Exception ex)
    {
        super();
        this.reason = ex;

    } /* end constructor */

    /**
     * Get the nested exception which explains why the 
     * event factory could not be created.
     * 
     * @return		The nested exception.
     */
    public Exception getReason()
    {
        return this.reason;

    } /* end method getReason() */

} /* end class CannotCreateEventFactoryException */
