/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: GenTestMethod.java,v 1.2 2005/04/22 14:51:08 bjiang Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.java.internal.codegen;

import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.test.common.internal.codegen.Helper;
import org.eclipse.hyades.ui.internal.util.StringUtil;

class GenTestMethod
{
  protected final String NL = System.getProperties().getProperty("line.separator");
  protected final String TEXT_1 = "\t\t" + NL;
  protected final String TEXT_2 = NL + "\t/**" + NL + "\t * ";
  protected final String TEXT_3 = NL + "\t *" + NL + "\t * ";
  protected final String TEXT_4 = NL + "\t * ";
  protected final String TEXT_5 = NL + "\t * @throws ";
  protected final String TEXT_6 = NL + "\t */" + NL + "\tpublic void ";
  protected final String TEXT_7 = "()" + NL + "\tthrows ";
  protected final String TEXT_8 = NL + "\t{" + NL + "\t\t";
  protected final String TEXT_9 = NL + "\t}" + NL + "\t" + NL;

	public String generate(ITestCase testCase, final Helper helper)
  {
    StringBuffer stringBuffer = new StringBuffer();
    stringBuffer.append(TEXT_1);
    
	class MethodBodyGenerator
	{
		public StringBuffer generate(ITestCase testCase)
		{
			StringBuffer sb = new StringBuffer();
			sb.append("// Enter your code here");
			return sb;
		}
	}

    
	MethodBodyGenerator methodBodyGenerator = new MethodBodyGenerator();
	String exceptionClassName = helper.getImportedName("java.lang.Exception");
	String code = methodBodyGenerator.generate(testCase).toString();
	String identifier = helper.getTestMethodName(testCase);

	if(identifier != null)
	{
		String description = testCase.getDescription();
		description = StringUtil.replace(description, NL, NL + " * ");	

    stringBuffer.append(TEXT_2);
    stringBuffer.append(testCase.getName());
    if(description != null){
    stringBuffer.append(TEXT_3);
    stringBuffer.append(description);
    stringBuffer.append(TEXT_4);
    }
    stringBuffer.append(TEXT_5);
    stringBuffer.append(exceptionClassName);
    stringBuffer.append(TEXT_6);
    stringBuffer.append(identifier);
    stringBuffer.append(TEXT_7);
    stringBuffer.append(exceptionClassName);
    stringBuffer.append(TEXT_8);
    stringBuffer.append(code);
    stringBuffer.append(TEXT_9);
    
	}

    
    return stringBuffer.toString();
  }
}
