/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SourceInfoSection.java,v 1.5 2005/02/16 22:21:44 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.java.internal.junit.editor;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;

import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.EditorSection;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class SourceInfoSection 
extends EditorSection
{	 
	private SourceInfoViewer sourceInfoViewer;

	/**
	 * Constructor for SourceInfoSection
	 * @param editorForm 
	 */
	public SourceInfoSection(EditorForm editorForm)
	{
		super(editorForm);
		setCollapsable(true);
	}
	
	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#dispose()
	 */
	public void dispose()
	{
		sourceInfoViewer.dispose();
		super.dispose();
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.FormSection#createClient(org.eclipse.swt.widgets.Composite, org.eclipse.update.ui.forms.internal.FormWidgetFactory)
	 */
	public Composite createClient(Composite parent, FormWidgetFactory formWidgetFactory)
	{
		sourceInfoViewer = new SourceInfoViewer()
		{
			protected boolean isReadOnly()
			{
				return SourceInfoSection.this.isReadOnly();
			}
		};
		return sourceInfoViewer.createClient(parent, this, getEditorForm().getWidgetFactory());
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseEditorSection#setInput(java.lang.Object)
	 */
	public void setInput(Object object)
	{
		sourceInfoViewer.setInput(object);
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseEditorSection#getInput()
	 */
	public Object getInput()
	{
		return sourceInfoViewer.getInput();
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseEditorSection#getStructuredSelection()
	 */
	public IStructuredSelection getStructuredSelection()
	{
		return sourceInfoViewer.getStructuredSelection();
	}
	
	/**
	 * @see org.eclipse.ui.part.ISetSelectionTarget#selectReveal(org.eclipse.jface.viewers.ISelection)
	 */
	public void selectReveal(ISelection selection)
	{
		sourceInfoViewer.selectReveal(selection);
	}
}