/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JUnitTestCaseNewWizard.java,v 1.5 2005/02/16 22:21:44 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.java.internal.junit.wizard;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.TestCommon;
import org.eclipse.hyades.test.common.internal.wizard.TestCaseNewWizard;
import org.eclipse.hyades.test.java.TestJavaImages;
import org.eclipse.hyades.test.java.TestJavaPlugin;

/**
 * Wizard for the JUnit Test Case
 * 
 * @author marcelop
 * @since 0.3.0
 */
public class JUnitTestCaseNewWizard
extends TestCaseNewWizard
{
	/**
	 * Constructor for TestCaseNewWizard
	 */
	public JUnitTestCaseNewWizard()
	{
		super();

		setWindowTitle(TestJavaPlugin.getString("WIZ_JUNIT_TST_CASE_TTL")); //$NON-NLS-1$
		setDefaultPageImageDescriptor(TestJavaImages.INSTANCE.getImageDescriptor(TestJavaImages.IMG_WIZBAN_NEW_JUNIT_TESTCASE));
	}

	/**
	 * Returns the type for the test case created by this wizard.
	 * @return String
	 */
	protected String getType()
	{
		return TestCommon.JUNIT_TEST_CASE_TYPE;
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
        ITestSuite testSuite = getTestSuite();
        String label = testSuite != null ? testSuite.getName() : ""; //$NON-NLS-1$

        getNameAndDescriptionWizardPage().setTitle(TestJavaPlugin.getString("WIZ_NEW_JUNIT_TST_CASE_PG_TTL")); //$NON-NLS-1$
        getNameAndDescriptionWizardPage().setDescription(TestJavaPlugin.getString("WIZ_NEW_JUNIT_TST_CASE_PG_ATT_DSC", label)); //$NON-NLS-1$
        addPage(getNameAndDescriptionWizardPage());
	}
}
