/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: JUnitTestSuiteNewWizard.java,v 1.5 2005/02/16 22:21:44 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.java.internal.junit.wizard;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.hyades.test.common.TestCommon;
import org.eclipse.hyades.test.common.internal.wizard.TestSuiteNewWizard;
import org.eclipse.hyades.test.java.TestJavaImages;
import org.eclipse.hyades.test.java.TestJavaPlugin;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.hyades.ui.internal.wizard.AttributeWizardPage;
import org.eclipse.hyades.ui.internal.wizard.LocationPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * Extends the HyadesNewWizard to create the JUnit Test Suite.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class JUnitTestSuiteNewWizard extends TestSuiteNewWizard {
    /**
     * Constructor for TestSuiteNewWizard
     */
    public JUnitTestSuiteNewWizard() {
        super();
        setWindowTitle(TestJavaPlugin.getString("WIZ_JUNIT_TST_SUITE_TTL")); //$NON-NLS-1$
        setDefaultPageImageDescriptor(TestJavaImages.INSTANCE.getImageDescriptor(TestJavaImages.IMG_WIZBAN_NEW_JUNIT_TESTSUITE));

        IDialogSettings dialogSettings = TestJavaPlugin.getInstance().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection("JUnitTestSuiteNewWizard"); //$NON-NLS-1$
        if (settings == null) settings = dialogSettings.addNewSection("JUnitTestSuiteNewWizard"); //$NON-NLS-1$
        setDialogSettings(settings);
    }

    /**
     * Returns the type for the test suite created by this wizard.
     * @return String
     */
    protected String getType() {
        return TestCommon.JUNIT_TEST_SUITE_TYPE;
    }

    /**
     * @see org.eclipse.jface.wizard.IWizard#addPages()
     */
    public void addPages() {
        getLocationPage().setTitle(TestJavaPlugin.getString("WIZ_NEW_JUNIT_TST_SUITE_PG_TTL")); //$NON-NLS-1$
        getLocationPage().setDescription(TestJavaPlugin.getString("WIZ_TST_SUITE_GEN_PG_LOC_DSC")); //$NON-NLS-1$

        getAttributeWizardPage().setTitle(TestJavaPlugin.getString("WIZ_NEW_JUNIT_TST_SUITE_PG_TTL")); //$NON-NLS-1$
        getAttributeWizardPage().setDescription(TestJavaPlugin.getString("WIZ_NEW_JUNIT_TST_SUITE_PG_ATT_DSC")); //$NON-NLS-1$

        super.addPages();
    }

    /**
     * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
     */
    protected void initPages() {
        IStructuredSelection structuredSelection = adjustSeletion();

        LocationPage locationPage = new LocationPage("location", structuredSelection) { //$NON-NLS-1$
            /** 
             * @see org.eclipse.ui.dialogs.WizardNewFileCreationPage#validatePage()
             */
            protected boolean validatePage() {
                setMessage(null);
                if (!super.validatePage()) {
                    return false;
                }

                if (!allowOverwrite()) {
                    IPath path = getContainerFullPath();
                    if (path != null) {
                        String fileName = getFileName();
                        if (fileName.length() == 0) {
                            setErrorMessage(null);
                            return false;
                        }
                        /*
                         * Test for any invalid characters within the file name or if it begins with
                         * a period.
                         */
                        String invalidChar = UIUtil.validateJavaFileName(fileName);
                        if (invalidChar != null) {
                            if (Character.isDigit(invalidChar.charAt(0))) {
                                String[] errors = { HyadesUIPlugin.getString("LOGICAL_NAME"), HyadesUIPlugin.getString("NUMERIC_VALUE")}; //$NON-NLS-1$ //$NON-NLS-2$
                                setErrorMessage(HyadesUIPlugin.getString("_ERROR_NAME_EXT", errors)); //$NON-NLS-1$
                                return false;
                            }
                            String[] errors = { HyadesUIPlugin.getString("LOGICAL_NAME"), invalidChar}; //$NON-NLS-1$
                            setErrorMessage(HyadesUIPlugin.getString("_ERROR_NAME_SPECIAL_CHAR", errors)); //$NON-NLS-1$
                            return false;
                        }
                        
                        int lastIndexOfExtension = fileName.lastIndexOf(getFileExtension());
                        if (lastIndexOfExtension > 0) {
                            String name = fileName.substring(0, lastIndexOfExtension - 1);
                            if (name.endsWith("." + getFileExtension())) { //$NON-NLS-1$
                                setMessage(HyadesUIPlugin.getString("_WARNING_FILE_NAME", fileName), IStatus.WARNING); //$NON-NLS-1$
                                return true;
                            }
                        }
                    }
                }
                return true;
            }
        };
        // Set the super.locationPage value
        setLocationPage(locationPage);

        String fileExtension = getFileExtension();
        if (fileExtension != null) {
            locationPage.setFileExtension(fileExtension);
            locationPage.setFileName(""); //$NON-NLS-1$
        }

        setAttributeWizardPage(new AttributeWizardPage("nameDescription")); //$NON-NLS-1$
    }
}