/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TypeValidator.java,v 1.5 2005/02/16 22:21:47 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.java.junit;

import org.eclipse.hyades.test.common.TestCommon;
import org.eclipse.hyades.ui.extension.ITypeValidator;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class TypeValidator 
implements ITypeValidator
{
	/**
	 * @see org.eclipse.hyades.ui.extension.ITypeValidator#isValidType(java.lang.String)
	 */
	public boolean isValidType(String type)
	{
		if(TestCommon.HTTP_JUNIT_TEST_SUITE_TYPE.equals(type))
			return true;

		if(TestCommon.HTTP_JUNIT_TEST_CASE_TYPE.equals(type))
			return true;

		if(TestCommon.JUNIT_TEST_SUITE_TYPE.equals(type))
			return true;

		if(TestCommon.JUNIT_TEST_CASE_TYPE.equals(type))
			return true;
			
		return false;
	}
}
