/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CommonPlugin.java,v 1.4 2005/04/22 14:52:46 bjiang Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.common;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class CommonPlugin 
extends Plugin
{
	public static final String PLUGIN_ID = "org.eclipse.hyades.models.common"; //$NON-NLS-1$
	private static CommonPlugin instance;
	private ResourceBundle resourceBundle;
	
	/**
	 * Constructor for CommonPlugin
	 * @param descriptor
	 */
	public CommonPlugin()
	{
		super();
		instance = this;
	}

	/**
	 * Returns the instance of this class created by the eclipse framework.
	 * @return HyadesUIPlugin
	 */
	public static CommonPlugin getInstance()
	{
		return instance;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.Plugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
	
		instance = null;
		savePluginPreferences();

		super.stop(context);
	}

	/**
	 * Returns this plugin's id.
	 * @return String
	 */
	public static String getID()
	{
		return PLUGIN_ID;
	}

	/**
	 * Returns the resource bundle used by this plugin.
	 * 
	 * <p>IMPORTANT: Don't use this method to retrieve values from the
	 * resource bundle.  For this purpose use the static <code>getString()</code> 
	 * defined in this class.
	 * 
	 * <p>This method is provided so this resource bundle can
	 * be used as the parent of another resource bundle.
	 * 
	 * @return ResourceBundle
	 */
	public ResourceBundle getResourceBundle()
	{
		if(resourceBundle == null)
		{
		
			try
			{
				resourceBundle = Platform.getResourceBundle(Platform.getBundle(PLUGIN_ID));
			}
			catch (Exception e) {
				resourceBundle = null;
			}
		}
		
		return resourceBundle;
	}
	
	/**
	 * Returns the "plugin.properties" file's value associate to a given key.
	 * @param key
	 * @return String
	 * @throws java.util.MissingResourceException if the key is not in the file
	 * @throws NullPointerException if key is null
	 */
	public static String getString(String key)
	throws NullPointerException, MissingResourceException
	{
		return instance.getResourceBundle().getString(key);
	}	
}
