/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CMNNodeTypeImpl.java,v 1.9 2005/03/28 21:51:32 jptoomey Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.common.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.hyades.models.common.common.CMNNodeType;
import org.eclipse.hyades.models.common.common.CommonPackage;

import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;

import org.eclipse.hyades.models.common.configuration.impl.CFGLocationImpl;

import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTimezone;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>CMN Node Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.common.impl.CMNNodeTypeImpl#getHostname <em>Hostname</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CMNNodeTypeImpl extends CFGLocationImpl implements CMNNodeType {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The default value of the '{@link #getHostname() <em>Hostname</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHostname()
	 * @generated
	 * @ordered
	 */
	protected static final String HOSTNAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getHostname() <em>Hostname</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHostname()
	 * @generated
	 * @ordered
	 */
	protected String hostname = HOSTNAME_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CMNNodeTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return CommonPackage.eINSTANCE.getCMNNodeType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getHostname() {
		return hostname;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHostname(String newHostname) {
		String oldHostname = hostname;
		hostname = newHostname;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, CommonPackage.CMN_NODE_TYPE__HOSTNAME, oldHostname, hostname));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case CommonPackage.CMN_NODE_TYPE__PROPERTY_GROUPS:
					return ((InternalEList)getPropertyGroups()).basicAdd(otherEnd, msgs);
				case CommonPackage.CMN_NODE_TYPE__DEPLOYMENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, CommonPackage.CMN_NODE_TYPE__DEPLOYMENT, msgs);
				case CommonPackage.CMN_NODE_TYPE__TIMEZONE:
					if (timezone != null)
						msgs = ((InternalEObject)timezone).eInverseRemove(this, Common_TestprofilePackage.TPF_TIMEZONE__LOCATIONS, TPFTimezone.class, msgs);
					return basicSetTimezone((TPFTimezone)otherEnd, msgs);
				case CommonPackage.CMN_NODE_TYPE__SUB_LOCATIONS:
					return ((InternalEList)getSubLocations()).basicAdd(otherEnd, msgs);
				case CommonPackage.CMN_NODE_TYPE__PARENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, CommonPackage.CMN_NODE_TYPE__PARENT, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case CommonPackage.CMN_NODE_TYPE__PROPERTY_GROUPS:
					return ((InternalEList)getPropertyGroups()).basicRemove(otherEnd, msgs);
				case CommonPackage.CMN_NODE_TYPE__DEPLOYMENT:
					return eBasicSetContainer(null, CommonPackage.CMN_NODE_TYPE__DEPLOYMENT, msgs);
				case CommonPackage.CMN_NODE_TYPE__TIMEZONE:
					return basicSetTimezone(null, msgs);
				case CommonPackage.CMN_NODE_TYPE__SUB_LOCATIONS:
					return ((InternalEList)getSubLocations()).basicRemove(otherEnd, msgs);
				case CommonPackage.CMN_NODE_TYPE__PARENT:
					return eBasicSetContainer(null, CommonPackage.CMN_NODE_TYPE__PARENT, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case CommonPackage.CMN_NODE_TYPE__DEPLOYMENT:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_TestprofilePackage.TPF_DEPLOYMENT__LOCATIONS, TPFDeployment.class, msgs);
				case CommonPackage.CMN_NODE_TYPE__PARENT:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_ConfigurationPackage.CFG_LOCATION__SUB_LOCATIONS, CFGLocation.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CommonPackage.CMN_NODE_TYPE__ID:
				return getId();
			case CommonPackage.CMN_NODE_TYPE__DESCRIPTION:
				return getDescription();
			case CommonPackage.CMN_NODE_TYPE__NAME:
				return getName();
			case CommonPackage.CMN_NODE_TYPE__PROPERTY_GROUPS:
				return getPropertyGroups();
			case CommonPackage.CMN_NODE_TYPE__DEPLOYMENT:
				return getDeployment();
			case CommonPackage.CMN_NODE_TYPE__TIMEZONE:
				if (resolve) return getTimezone();
				return basicGetTimezone();
			case CommonPackage.CMN_NODE_TYPE__SUB_LOCATIONS:
				return getSubLocations();
			case CommonPackage.CMN_NODE_TYPE__PARENT:
				return getParent();
			case CommonPackage.CMN_NODE_TYPE__REF_SUB_LOCATIONS:
				return getRefSubLocations();
			case CommonPackage.CMN_NODE_TYPE__HOSTNAME:
				return getHostname();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CommonPackage.CMN_NODE_TYPE__ID:
				setId((String)newValue);
				return;
			case CommonPackage.CMN_NODE_TYPE__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case CommonPackage.CMN_NODE_TYPE__NAME:
				setName((String)newValue);
				return;
			case CommonPackage.CMN_NODE_TYPE__PROPERTY_GROUPS:
				getPropertyGroups().clear();
				getPropertyGroups().addAll((Collection)newValue);
				return;
			case CommonPackage.CMN_NODE_TYPE__DEPLOYMENT:
				setDeployment((TPFDeployment)newValue);
				return;
			case CommonPackage.CMN_NODE_TYPE__TIMEZONE:
				setTimezone((TPFTimezone)newValue);
				return;
			case CommonPackage.CMN_NODE_TYPE__SUB_LOCATIONS:
				getSubLocations().clear();
				getSubLocations().addAll((Collection)newValue);
				return;
			case CommonPackage.CMN_NODE_TYPE__PARENT:
				setParent((CFGLocation)newValue);
				return;
			case CommonPackage.CMN_NODE_TYPE__REF_SUB_LOCATIONS:
				getRefSubLocations().clear();
				getRefSubLocations().addAll((Collection)newValue);
				return;
			case CommonPackage.CMN_NODE_TYPE__HOSTNAME:
				setHostname((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CommonPackage.CMN_NODE_TYPE__ID:
				setId(ID_EDEFAULT);
				return;
			case CommonPackage.CMN_NODE_TYPE__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case CommonPackage.CMN_NODE_TYPE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case CommonPackage.CMN_NODE_TYPE__PROPERTY_GROUPS:
				getPropertyGroups().clear();
				return;
			case CommonPackage.CMN_NODE_TYPE__DEPLOYMENT:
				setDeployment((TPFDeployment)null);
				return;
			case CommonPackage.CMN_NODE_TYPE__TIMEZONE:
				setTimezone((TPFTimezone)null);
				return;
			case CommonPackage.CMN_NODE_TYPE__SUB_LOCATIONS:
				getSubLocations().clear();
				return;
			case CommonPackage.CMN_NODE_TYPE__PARENT:
				setParent((CFGLocation)null);
				return;
			case CommonPackage.CMN_NODE_TYPE__REF_SUB_LOCATIONS:
				getRefSubLocations().clear();
				return;
			case CommonPackage.CMN_NODE_TYPE__HOSTNAME:
				setHostname(HOSTNAME_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case CommonPackage.CMN_NODE_TYPE__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case CommonPackage.CMN_NODE_TYPE__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case CommonPackage.CMN_NODE_TYPE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case CommonPackage.CMN_NODE_TYPE__PROPERTY_GROUPS:
				return propertyGroups != null && !propertyGroups.isEmpty();
			case CommonPackage.CMN_NODE_TYPE__DEPLOYMENT:
				return getDeployment() != null;
			case CommonPackage.CMN_NODE_TYPE__TIMEZONE:
				return timezone != null;
			case CommonPackage.CMN_NODE_TYPE__SUB_LOCATIONS:
				return subLocations != null && !subLocations.isEmpty();
			case CommonPackage.CMN_NODE_TYPE__PARENT:
				return getParent() != null;
			case CommonPackage.CMN_NODE_TYPE__REF_SUB_LOCATIONS:
				return refSubLocations != null && !refSubLocations.isEmpty();
			case CommonPackage.CMN_NODE_TYPE__HOSTNAME:
				return HOSTNAME_EDEFAULT == null ? hostname != null : !HOSTNAME_EDEFAULT.equals(hostname);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (hostname: ");
		result.append(hostname);
		result.append(')');
		return result.toString();
	}

} //CMNNodeTypeImpl
