/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CFGLocationImpl.java,v 1.11 2005/03/28 21:51:31 jptoomey Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.configuration.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTimezone;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>CFG Location</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGLocationImpl#getDeployment <em>Deployment</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGLocationImpl#getTimezone <em>Timezone</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGLocationImpl#getSubLocations <em>Sub Locations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGLocationImpl#getParent <em>Parent</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGLocationImpl#getRefSubLocations <em>Ref Sub Locations</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CFGLocationImpl extends CFGConfigurableObjectImpl implements CFGLocation
{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The cached value of the '{@link #getTimezone() <em>Timezone</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimezone()
	 * @generated
	 * @ordered
	 */
	protected TPFTimezone timezone = null;

	/**
	 * The cached value of the '{@link #getSubLocations() <em>Sub Locations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSubLocations()
	 * @generated
	 * @ordered
	 */
	protected EList subLocations = null;

	/**
	 * The cached value of the '{@link #getRefSubLocations() <em>Ref Sub Locations</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRefSubLocations()
	 * @generated
	 * @ordered
	 */
	protected EList refSubLocations = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CFGLocationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return Common_ConfigurationPackage.eINSTANCE.getCFGLocation();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFDeployment getDeployment() {
		if (eContainerFeatureID != Common_ConfigurationPackage.CFG_LOCATION__DEPLOYMENT) return null;
		return (TPFDeployment)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDeployment(TPFDeployment newDeployment) {
		if (newDeployment != eContainer || (eContainerFeatureID != Common_ConfigurationPackage.CFG_LOCATION__DEPLOYMENT && newDeployment != null)) {
			if (EcoreUtil.isAncestor(this, newDeployment))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newDeployment != null)
				msgs = ((InternalEObject)newDeployment).eInverseAdd(this, Common_TestprofilePackage.TPF_DEPLOYMENT__LOCATIONS, TPFDeployment.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newDeployment, Common_ConfigurationPackage.CFG_LOCATION__DEPLOYMENT, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_LOCATION__DEPLOYMENT, newDeployment, newDeployment));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFTimezone getTimezone() {
		if (timezone != null && timezone.eIsProxy()) {
			TPFTimezone oldTimezone = timezone;
			timezone = (TPFTimezone)eResolveProxy((InternalEObject)timezone);
			if (timezone != oldTimezone) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_ConfigurationPackage.CFG_LOCATION__TIMEZONE, oldTimezone, timezone));
			}
		}
		return timezone;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFTimezone basicGetTimezone() {
		return timezone;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTimezone(TPFTimezone newTimezone, NotificationChain msgs) {
		TPFTimezone oldTimezone = timezone;
		timezone = newTimezone;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_LOCATION__TIMEZONE, oldTimezone, newTimezone);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTimezone(TPFTimezone newTimezone) {
		if (newTimezone != timezone) {
			NotificationChain msgs = null;
			if (timezone != null)
				msgs = ((InternalEObject)timezone).eInverseRemove(this, Common_TestprofilePackage.TPF_TIMEZONE__LOCATIONS, TPFTimezone.class, msgs);
			if (newTimezone != null)
				msgs = ((InternalEObject)newTimezone).eInverseAdd(this, Common_TestprofilePackage.TPF_TIMEZONE__LOCATIONS, TPFTimezone.class, msgs);
			msgs = basicSetTimezone(newTimezone, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_LOCATION__TIMEZONE, newTimezone, newTimezone));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getSubLocations() {
		if (subLocations == null) {
			subLocations = new EObjectContainmentWithInverseEList(CFGLocation.class, this, Common_ConfigurationPackage.CFG_LOCATION__SUB_LOCATIONS, Common_ConfigurationPackage.CFG_LOCATION__PARENT);
		}
		return subLocations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CFGLocation getParent() {
		if (eContainerFeatureID != Common_ConfigurationPackage.CFG_LOCATION__PARENT) return null;
		return (CFGLocation)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParent(CFGLocation newParent) {
		if (newParent != eContainer || (eContainerFeatureID != Common_ConfigurationPackage.CFG_LOCATION__PARENT && newParent != null)) {
			if (EcoreUtil.isAncestor(this, newParent))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newParent != null)
				msgs = ((InternalEObject)newParent).eInverseAdd(this, Common_ConfigurationPackage.CFG_LOCATION__SUB_LOCATIONS, CFGLocation.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newParent, Common_ConfigurationPackage.CFG_LOCATION__PARENT, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_LOCATION__PARENT, newParent, newParent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getRefSubLocations() {
		if (refSubLocations == null) {
			refSubLocations = new EObjectResolvingEList(CFGLocation.class, this, Common_ConfigurationPackage.CFG_LOCATION__REF_SUB_LOCATIONS);
		}
		return refSubLocations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_ConfigurationPackage.CFG_LOCATION__PROPERTY_GROUPS:
					return ((InternalEList)getPropertyGroups()).basicAdd(otherEnd, msgs);
				case Common_ConfigurationPackage.CFG_LOCATION__DEPLOYMENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, Common_ConfigurationPackage.CFG_LOCATION__DEPLOYMENT, msgs);
				case Common_ConfigurationPackage.CFG_LOCATION__TIMEZONE:
					if (timezone != null)
						msgs = ((InternalEObject)timezone).eInverseRemove(this, Common_TestprofilePackage.TPF_TIMEZONE__LOCATIONS, TPFTimezone.class, msgs);
					return basicSetTimezone((TPFTimezone)otherEnd, msgs);
				case Common_ConfigurationPackage.CFG_LOCATION__SUB_LOCATIONS:
					return ((InternalEList)getSubLocations()).basicAdd(otherEnd, msgs);
				case Common_ConfigurationPackage.CFG_LOCATION__PARENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, Common_ConfigurationPackage.CFG_LOCATION__PARENT, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_ConfigurationPackage.CFG_LOCATION__PROPERTY_GROUPS:
					return ((InternalEList)getPropertyGroups()).basicRemove(otherEnd, msgs);
				case Common_ConfigurationPackage.CFG_LOCATION__DEPLOYMENT:
					return eBasicSetContainer(null, Common_ConfigurationPackage.CFG_LOCATION__DEPLOYMENT, msgs);
				case Common_ConfigurationPackage.CFG_LOCATION__TIMEZONE:
					return basicSetTimezone(null, msgs);
				case Common_ConfigurationPackage.CFG_LOCATION__SUB_LOCATIONS:
					return ((InternalEList)getSubLocations()).basicRemove(otherEnd, msgs);
				case Common_ConfigurationPackage.CFG_LOCATION__PARENT:
					return eBasicSetContainer(null, Common_ConfigurationPackage.CFG_LOCATION__PARENT, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case Common_ConfigurationPackage.CFG_LOCATION__DEPLOYMENT:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_TestprofilePackage.TPF_DEPLOYMENT__LOCATIONS, TPFDeployment.class, msgs);
				case Common_ConfigurationPackage.CFG_LOCATION__PARENT:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_ConfigurationPackage.CFG_LOCATION__SUB_LOCATIONS, CFGLocation.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_LOCATION__ID:
				return getId();
			case Common_ConfigurationPackage.CFG_LOCATION__DESCRIPTION:
				return getDescription();
			case Common_ConfigurationPackage.CFG_LOCATION__NAME:
				return getName();
			case Common_ConfigurationPackage.CFG_LOCATION__PROPERTY_GROUPS:
				return getPropertyGroups();
			case Common_ConfigurationPackage.CFG_LOCATION__DEPLOYMENT:
				return getDeployment();
			case Common_ConfigurationPackage.CFG_LOCATION__TIMEZONE:
				if (resolve) return getTimezone();
				return basicGetTimezone();
			case Common_ConfigurationPackage.CFG_LOCATION__SUB_LOCATIONS:
				return getSubLocations();
			case Common_ConfigurationPackage.CFG_LOCATION__PARENT:
				return getParent();
			case Common_ConfigurationPackage.CFG_LOCATION__REF_SUB_LOCATIONS:
				return getRefSubLocations();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_LOCATION__ID:
				setId((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_LOCATION__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_LOCATION__NAME:
				setName((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_LOCATION__PROPERTY_GROUPS:
				getPropertyGroups().clear();
				getPropertyGroups().addAll((Collection)newValue);
				return;
			case Common_ConfigurationPackage.CFG_LOCATION__DEPLOYMENT:
				setDeployment((TPFDeployment)newValue);
				return;
			case Common_ConfigurationPackage.CFG_LOCATION__TIMEZONE:
				setTimezone((TPFTimezone)newValue);
				return;
			case Common_ConfigurationPackage.CFG_LOCATION__SUB_LOCATIONS:
				getSubLocations().clear();
				getSubLocations().addAll((Collection)newValue);
				return;
			case Common_ConfigurationPackage.CFG_LOCATION__PARENT:
				setParent((CFGLocation)newValue);
				return;
			case Common_ConfigurationPackage.CFG_LOCATION__REF_SUB_LOCATIONS:
				getRefSubLocations().clear();
				getRefSubLocations().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_LOCATION__ID:
				setId(ID_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_LOCATION__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_LOCATION__NAME:
				setName(NAME_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_LOCATION__PROPERTY_GROUPS:
				getPropertyGroups().clear();
				return;
			case Common_ConfigurationPackage.CFG_LOCATION__DEPLOYMENT:
				setDeployment((TPFDeployment)null);
				return;
			case Common_ConfigurationPackage.CFG_LOCATION__TIMEZONE:
				setTimezone((TPFTimezone)null);
				return;
			case Common_ConfigurationPackage.CFG_LOCATION__SUB_LOCATIONS:
				getSubLocations().clear();
				return;
			case Common_ConfigurationPackage.CFG_LOCATION__PARENT:
				setParent((CFGLocation)null);
				return;
			case Common_ConfigurationPackage.CFG_LOCATION__REF_SUB_LOCATIONS:
				getRefSubLocations().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_LOCATION__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case Common_ConfigurationPackage.CFG_LOCATION__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case Common_ConfigurationPackage.CFG_LOCATION__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case Common_ConfigurationPackage.CFG_LOCATION__PROPERTY_GROUPS:
				return propertyGroups != null && !propertyGroups.isEmpty();
			case Common_ConfigurationPackage.CFG_LOCATION__DEPLOYMENT:
				return getDeployment() != null;
			case Common_ConfigurationPackage.CFG_LOCATION__TIMEZONE:
				return timezone != null;
			case Common_ConfigurationPackage.CFG_LOCATION__SUB_LOCATIONS:
				return subLocations != null && !subLocations.isEmpty();
			case Common_ConfigurationPackage.CFG_LOCATION__PARENT:
				return getParent() != null;
			case Common_ConfigurationPackage.CFG_LOCATION__REF_SUB_LOCATIONS:
				return refSubLocations != null && !refSubLocations.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

} //CFGLocationImpl
