/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DPLDatapoolImpl.java,v 1.14 2005/03/28 21:51:32 jptoomey Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.datapool.impl;

import java.util.Collection;
import java.util.ListIterator;

import org.eclipse.core.internal.runtime.ListenerList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.edit.datapool.IDatapoolRecord;
import org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.execution.runtime.datapool.DatapoolException;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator;
import org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolFactory;
import org.eclipse.hyades.models.common.datapool.Common_DatapoolPackage;
import org.eclipse.hyades.models.common.datapool.DPLCell;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLDatapoolSpec;
import org.eclipse.hyades.models.common.datapool.DPLEquivalenceClass;
import org.eclipse.hyades.models.common.datapool.DPLRecord;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.util.DatapoolUtil;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>DPL Datapool</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolImpl#getEquivalenceClasses <em>Equivalence Classes</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolImpl#getDatapoolSpec <em>Datapool Spec</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DPLDatapoolImpl
	extends CFGClassImpl
	implements DPLDatapool {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The cached value of the '{@link #getEquivalenceClasses() <em>Equivalence Classes</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEquivalenceClasses()
	 * @generated
	 * @ordered
	 */
	protected EList equivalenceClasses = null;

	/**
	 * The cached value of the '{@link #getDatapoolSpec() <em>Datapool Spec</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDatapoolSpec()
	 * @generated
	 * @ordered
	 */
	protected DPLDatapoolSpec datapoolSpec = null;

	/**
	 * default equivalence class
	 *
	 */
	protected int defaultEquivalenceClass = 0;

	/**
	 * listener associated with this datapool
	 */
	protected ListenerList listenerList = new ListenerList();

	/**
	 * absolute file pathname for a file from which the datapool was recently loaded
	 * Used as key for datapool caching
	 */
	String absoluteFilePathname;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DPLDatapoolImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return Common_DatapoolPackage.eINSTANCE.getDPLDatapool();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getEquivalenceClasses() {
		if (equivalenceClasses == null) {
			equivalenceClasses = new EObjectContainmentEList(DPLEquivalenceClass.class, this, Common_DatapoolPackage.DPL_DATAPOOL__EQUIVALENCE_CLASSES);
		}
		return equivalenceClasses;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DPLDatapoolSpec getDatapoolSpec() {
		return datapoolSpec;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDatapoolSpec(DPLDatapoolSpec newDatapoolSpec, NotificationChain msgs) {
		DPLDatapoolSpec oldDatapoolSpec = datapoolSpec;
		datapoolSpec = newDatapoolSpec;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_DatapoolPackage.DPL_DATAPOOL__DATAPOOL_SPEC, oldDatapoolSpec, newDatapoolSpec);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDatapoolSpec(DPLDatapoolSpec newDatapoolSpec) {
		if (newDatapoolSpec != datapoolSpec) {
			NotificationChain msgs = null;
			if (datapoolSpec != null)
				msgs = ((InternalEObject)datapoolSpec).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Common_DatapoolPackage.DPL_DATAPOOL__DATAPOOL_SPEC, null, msgs);
			if (newDatapoolSpec != null)
				msgs = ((InternalEObject)newDatapoolSpec).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - Common_DatapoolPackage.DPL_DATAPOOL__DATAPOOL_SPEC, null, msgs);
			msgs = basicSetDatapoolSpec(newDatapoolSpec, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_DatapoolPackage.DPL_DATAPOOL__DATAPOOL_SPEC, newDatapoolSpec, newDatapoolSpec));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_DatapoolPackage.DPL_DATAPOOL__OPERATIONS:
					return ((InternalEList)getOperations()).basicAdd(otherEnd, msgs);
				case Common_DatapoolPackage.DPL_DATAPOOL__INSTANCES:
					return ((InternalEList)getInstances()).basicAdd(otherEnd, msgs);
				case Common_DatapoolPackage.DPL_DATAPOOL__INSTANTIATIONS:
					return ((InternalEList)getInstantiations()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_DatapoolPackage.DPL_DATAPOOL__OPERATIONS:
					return ((InternalEList)getOperations()).basicRemove(otherEnd, msgs);
				case Common_DatapoolPackage.DPL_DATAPOOL__INSTANCES:
					return ((InternalEList)getInstances()).basicRemove(otherEnd, msgs);
				case Common_DatapoolPackage.DPL_DATAPOOL__INSTANTIATIONS:
					return ((InternalEList)getInstantiations()).basicRemove(otherEnd, msgs);
				case Common_DatapoolPackage.DPL_DATAPOOL__EQUIVALENCE_CLASSES:
					return ((InternalEList)getEquivalenceClasses()).basicRemove(otherEnd, msgs);
				case Common_DatapoolPackage.DPL_DATAPOOL__DATAPOOL_SPEC:
					return basicSetDatapoolSpec(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_DATAPOOL__ID:
				return getId();
			case Common_DatapoolPackage.DPL_DATAPOOL__DESCRIPTION:
				return getDescription();
			case Common_DatapoolPackage.DPL_DATAPOOL__NAME:
				return getName();
			case Common_DatapoolPackage.DPL_DATAPOOL__OPERATIONS:
				return getOperations();
			case Common_DatapoolPackage.DPL_DATAPOOL__INSTANCES:
				return getInstances();
			case Common_DatapoolPackage.DPL_DATAPOOL__INSTANTIATIONS:
				return getInstantiations();
			case Common_DatapoolPackage.DPL_DATAPOOL__EQUIVALENCE_CLASSES:
				return getEquivalenceClasses();
			case Common_DatapoolPackage.DPL_DATAPOOL__DATAPOOL_SPEC:
				return getDatapoolSpec();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_DATAPOOL__ID:
				setId((String)newValue);
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__NAME:
				setName((String)newValue);
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__OPERATIONS:
				getOperations().clear();
				getOperations().addAll((Collection)newValue);
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__INSTANCES:
				getInstances().clear();
				getInstances().addAll((Collection)newValue);
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__INSTANTIATIONS:
				getInstantiations().clear();
				getInstantiations().addAll((Collection)newValue);
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__EQUIVALENCE_CLASSES:
				getEquivalenceClasses().clear();
				getEquivalenceClasses().addAll((Collection)newValue);
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__DATAPOOL_SPEC:
				setDatapoolSpec((DPLDatapoolSpec)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_DATAPOOL__ID:
				setId(ID_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__NAME:
				setName(NAME_EDEFAULT);
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__OPERATIONS:
				getOperations().clear();
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__INSTANCES:
				getInstances().clear();
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__INSTANTIATIONS:
				getInstantiations().clear();
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__EQUIVALENCE_CLASSES:
				getEquivalenceClasses().clear();
				return;
			case Common_DatapoolPackage.DPL_DATAPOOL__DATAPOOL_SPEC:
				setDatapoolSpec((DPLDatapoolSpec)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_DatapoolPackage.DPL_DATAPOOL__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case Common_DatapoolPackage.DPL_DATAPOOL__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case Common_DatapoolPackage.DPL_DATAPOOL__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case Common_DatapoolPackage.DPL_DATAPOOL__OPERATIONS:
				return operations != null && !operations.isEmpty();
			case Common_DatapoolPackage.DPL_DATAPOOL__INSTANCES:
				return instances != null && !instances.isEmpty();
			case Common_DatapoolPackage.DPL_DATAPOOL__INSTANTIATIONS:
				return instantiations != null && !instantiations.isEmpty();
			case Common_DatapoolPackage.DPL_DATAPOOL__EQUIVALENCE_CLASSES:
				return equivalenceClasses != null && !equivalenceClasses.isEmpty();
			case Common_DatapoolPackage.DPL_DATAPOOL__DATAPOOL_SPEC:
				return datapoolSpec != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl#getLocation()
	 */
	public String getLocation() {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl#getOwner()
	 */
	public ITest getOwner() {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl#getResource()
	 */
	public String getResource() {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl#setLocation(java.lang.String)
	 */
	public void setLocation(String location) {
		// TODO Auto-generated method stub
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl#setResource(java.lang.String)
	 */
	public void setResource(String resource) {
		// TODO Auto-generated method stub
		
	}

	//beginning of non-generated classes

	//org.eclipse.hyades.edit.datapool.IDatapool methods

	/**
	 * Update the variable at a specified zero based variable index.
	 * 
	 * @param	variable		The variable for the cells at <i>variableIndex</i>.
	 * @param	variableIndex	A zero based variable index.
	 * 
	 * @see #getVariableIndex(String)
	 * @see #getVariableIndexById(String)
	 * @see #getVariable(int)
	 */
	public void updateVariable(IDatapoolVariable variable, int variableIndex) {

		this.removeVariableDoNotNotify(variableIndex);
		this.insertVariableDoNotNotify(variable, variableIndex);

		//notify listeners
		Object[] listeners = listenerList.getListeners();
		for(int i = 0; i < listeners.length; i++)
			((IDatapoolListener)listeners[i]).variableChanged(this, variableIndex);
	}

	/**
	 * Insert a variable before the variable at the specified zero based
	 * variable index.  This action will cause an empty cell to be 
	 * automatically inserted in each row of the datapool.
	 * 
	 * @param	variable		The new variable for the cells at <i>beforeVariableIndex</i>.
	 * @param	beforeVariableIndex	A zero based variable index.
	 * 
	 * @see #appendVariable(IDatapoolVariable)
	 * @see #moveVariable(int,int)
	 * @see #removeVariable(int)
	 */
	public void insertVariable(IDatapoolVariable variable, int beforeVariableIndex) {
        
		this.insertVariableDoNotNotify(variable, beforeVariableIndex);

//		notify listeners
		Object[] listeners = listenerList.getListeners();
		for(int i = 0; i < listeners.length; i++)
		    ((IDatapoolListener)listeners[i]).variableAdded(this, beforeVariableIndex);
	}


	/**
	 * Helper function
	 * Insert a variable before the variable at the specified zero based
	 * variable index.  Do not notify listeners.
	 * 
	 * @param	variable		The new variable for the cells at <i>beforeVariableIndex</i>.
	 * @param	beforeVariableIndex	A zero based variable index.
	 * 
	 */
	protected void insertVariableDoNotNotify(IDatapoolVariable variable, int beforeVariableIndex) {
		//add variable
		this.getDatapoolSpec().getVariables().add(beforeVariableIndex, variable);

		//iterate through equivalence classes
		ListIterator ecIter = this.getEquivalenceClasses().listIterator();
		while (ecIter.hasNext()) {

			DPLEquivalenceClass ec = (DPLEquivalenceClass) ecIter.next();

			//iterate through records of this equivalence class
			ListIterator recIter = ec.getRecords().listIterator();
			while (recIter.hasNext()) {
				DPLRecord rec = (DPLRecord) recIter.next();
				//insert new cell
				DPLCell newCell =
					Common_DatapoolFactory.eINSTANCE.createDPLCell();
				newCell.setVariable((DPLVariable) variable);
				((org.eclipse.hyades.models.common.datapool.impl.DPLRecordImpl)rec)
							.insertCell(newCell, beforeVariableIndex);
			}
		}
	}


	/**
	 * Append a variable to the end of the datapool ordered variable collection.
	 * This action will cause an empty cell to be automatically appended to each record 
	 * of the datapool.
	 * 
	 * @param	variable		The variable instance to append.
	 * 
	 * @see #insertVariable(IDatapoolVariable,int)
	 * @see #moveVariable(int,int)
	 * @see #removeVariable(int)
	 */
	public void appendVariable(IDatapoolVariable variable) {
		this.insertVariable(variable, this.getDatapoolSpec().getVariables().size());
	}

	/**
	 * Move a variable to immediately before another variable.  The variables are
	 * denoted by a zero based variable index.  This action will cause the
	 * associated cells in each row of the datapool to also be moved.
	 * 
	 * @param	sourceVariableIndex		A zero based variable index for the 
	 * 									variable to be moved.
	 * @param	targetVariableIndex		The variable index marking the target 
	 * 									location for the move action.
	 * 
	 * @see #insertVariable(IDatapoolVariable,int)
	 * @see #appendVariable(IDatapoolVariable)
	 * @see #removeVariable(int)
	 */
	public void moveVariable(int sourceVariableIndex, int targetVariableIndex) {

	   DPLVariable var = (DPLVariable)(this.getDatapoolSpec().getVariables().remove(sourceVariableIndex));
	   this.getDatapoolSpec().getVariables().add(targetVariableIndex, var);
       
	   //iterate through equivalence classes
	   ListIterator ecIter = this.getEquivalenceClasses().listIterator();
	   while (ecIter.hasNext()) {

		   DPLEquivalenceClass ec = (DPLEquivalenceClass) ecIter.next();

		   //iterate through records of this equivalence class
		   ListIterator recIter = ec.getRecords().listIterator();
		   while (recIter.hasNext()) {
			   DPLRecord rec = (DPLRecord) recIter.next();
			   
			   //move cells
			   DPLCell cell = (DPLCell)(rec.getCells().remove(sourceVariableIndex));
			   rec.getCells().add(targetVariableIndex, cell);

		   }
	   }       

	   	// notify listeners
		Object[] listeners = listenerList.getListeners();
		for(int i = 0; i < listeners.length; i++)
			((IDatapoolListener)listeners[i]).variableMoved(this, sourceVariableIndex, targetVariableIndex);
	}

	/**
	 * Remove the specified variable from the datapool.  The specified variable
	 * index is zero based.  Each record in the datapool is automatically 
	 * updated to remove the cell that coincides with the variable.
	 * 
	 * @param	variableIndex	A zero based variable index for the variable to 
	 *							be removed.
	 * 
	 * @see #insertVariable(IDatapoolVariable,int)
	 * @see #appendVariable(IDatapoolVariable)
	 * @see #moveVariable(int,int)
	 */
	public void removeVariable(int variableIndex) {
		
		this.removeVariableDoNotNotify(variableIndex);

		//notify listeners
		Object[] listeners = listenerList.getListeners();
		for(int i = 0; i < listeners.length; i++)
			((IDatapoolListener)listeners[i]).variableRemoved(this, variableIndex);

	}
	
	/**
	 * Helper function
	 * Remove the specified variable from the datapool.  
	 * Do not notify listeners
	 * 
	 * @param	variableIndex	A zero based variable index for the variable to 
	 *							be removed.
	 * 
	 */
	protected void removeVariableDoNotNotify(int variableIndex) {
		this.getDatapoolSpec().getVariables().remove(variableIndex);

		//iterate through equivalence classes
		ListIterator ecIter = this.getEquivalenceClasses().listIterator();
		while (ecIter.hasNext()) {

			DPLEquivalenceClass ec = (DPLEquivalenceClass) ecIter.next();

			//iterate through records of this equivalence class
			ListIterator recIter = ec.getRecords().listIterator();
			while (recIter.hasNext()) {
				DPLRecord rec = (DPLRecord) recIter.next();
				//remove cell at variableIndex
				rec.getCells().remove(variableIndex);
			}
		}
	}
	

	//************************************************************
	// These methods provide support for the logical equivalence classes
	// associated with an instance of a datapool.
	//************************************************************

	/**
	 * Define the default {@link IDatapoolEquivalenceClass equivalence class}
	 * in a datapool.
	 * 
	 * @param equivalenceClassIndex The zero-based index for the default equivalence class.
	 * 
	 * @see #getDefaultEquivalenceClassIndex()
	 */
	public void setDefaultEquivalenceClassIndex(int equivalenceClassIndex) {
		defaultEquivalenceClass = equivalenceClassIndex;
	}

	/**
	 * Replace the {@link IDatapoolEquivalenceClass equivalence class} at a 
	 * supplied index with a new value.  This method is essentially a 
	 * shortcut for a call to {@link #removeEquivalenceClass(int) removeEquivalenceClass}
	 * followed by a call to 
	 * {@link #insertEquivalenceClass(IDatapoolEquivalenceClass,int) insertEquivalenceClass}.
	 * 
	 * @param	equivalenceClass	The equivalence class to insert.
	 * @param	equivalenceClassIndex	The equivalence class indsex to remove and insert at.
	 * 
	 * @see #insertEquivalenceClass(IDatapoolEquivalenceClass,int)
	 * @see #appendEquivalenceClass(IDatapoolEquivalenceClass)
	 * @see #moveEquivalenceClass(int,int)
	 * @see #removeEquivalenceClass(int)
	 */
	public void updateEquivalenceClass(IDatapoolEquivalenceClass equivalenceClass, int equivalenceClassIndex) {
		this.removeEquivalenceClassDoNotNotify(equivalenceClassIndex);
		this.insertEquivalenceClassDoNotNotify(equivalenceClass, equivalenceClassIndex);
		
		//notify listeners
		Object[] listeners = listenerList.getListeners();
		for(int i = 0; i < listeners.length; i++)
			((IDatapoolListener)listeners[i]).equivalenceClassChanged(this, equivalenceClassIndex);	
	}

	/**
	 * Insert the {@link IDatapoolEquivalenceClass equivalence class} at a 
	 * supplied index.  The {@link IDatapoolRecord records} in the equivalence 
	 * class must match the layout of all other records in the datapool.
	 * 
	 * @param	equivalenceClass	The equivalence class to insert.
	 * @param	beforeEquivalenceClassIndex	The equivalence class index to insert before.
	 * 
	 * @see #updateEquivalenceClass(IDatapoolEquivalenceClass,int)
	 * @see #appendEquivalenceClass(IDatapoolEquivalenceClass)
	 * @see #moveEquivalenceClass(int,int)
	 * @see #removeEquivalenceClass(int)
	 */
	public void insertEquivalenceClass(IDatapoolEquivalenceClass equivalenceClass, int beforeEquivalenceClassIndex) {
		this.insertEquivalenceClassDoNotNotify(equivalenceClass, beforeEquivalenceClassIndex);
		
		//notify listeners
		Object[] listeners = listenerList.getListeners();
		for(int i = 0; i < listeners.length; i++)
			((IDatapoolListener)listeners[i]).equivalenceClassAdded(this, beforeEquivalenceClassIndex);
	}
	
	/**
	 * Helper function
	 * Insert the {@link IDatapoolEquivalenceClass equivalence class} at a 
	 * supplied index.  Do not notify listeners.
	 * 
	 * @param	equivalenceClass	The equivalence class to insert.
	 * @param	beforeEquivalenceClassIndex	The equivalence class index to insert before.
	 * 
	 */
	protected void insertEquivalenceClassDoNotNotify(IDatapoolEquivalenceClass equivalenceClass, int beforeEquivalenceClassIndex) {
		this.getEquivalenceClasses().add(
			beforeEquivalenceClassIndex,
			equivalenceClass);
	}

	/**
	 * Append the supplied {@link IDatapoolEquivalenceClass equivalence class} to the end 
	 * of the set of available equivalence classes.  The {@link IDatapoolRecord records} in 
	 * the equivalence class must match the layout of all other records in the datapool.
	 * 
	 * @param	equivalenceClass	The equivalence class to append.
	 * 
	 * @see #updateEquivalenceClass(IDatapoolEquivalenceClass,int)
	 * @see #insertEquivalenceClass(IDatapoolEquivalenceClass,int)
	 * @see #moveEquivalenceClass(int,int)
	 * @see #removeEquivalenceClass(int)
	 */
	public void appendEquivalenceClass(IDatapoolEquivalenceClass equivalenceClass) {
		this.insertEquivalenceClass(equivalenceClass, this.getEquivalenceClasses().size());
	}

	/**
	 * Move the {@link IDatapoolEquivalenceClass equivalence class} at a 
	 * supplied index to a new position within the set of available equivalence classes.
	 * 
	 * @param	sourceEquivalenceClassIndex	The equivalence class index to move.
	 * @param	targetEquivalenceClassIndex	The equivalence class destination index.
	 * 
	 * @see #updateEquivalenceClass(IDatapoolEquivalenceClass,int)
	 * @see #insertEquivalenceClass(IDatapoolEquivalenceClass,int)
	 * @see #appendEquivalenceClass(IDatapoolEquivalenceClass)
	 * @see #removeEquivalenceClass(int)
	 */
	public void moveEquivalenceClass(int sourceEquivalenceClassIndex, int targetEquivalenceClassIndex) {

		DPLEquivalenceClass ec = (DPLEquivalenceClass) (this.getEquivalenceClasses().get(sourceEquivalenceClassIndex));
		/*if(sourceEquivalenceClassIndex > targetEquivalenceClassIndex)
		{
			this.removeEquivalenceClassDoNotNotify(sourceEquivalenceClassIndex);
			this.insertEquivalenceClassDoNotNotify((IDatapoolEquivalenceClass)ec, targetEquivalenceClassIndex + 1);
		}
		else*/
		{
			this.removeEquivalenceClassDoNotNotify(sourceEquivalenceClassIndex);
			this.insertEquivalenceClassDoNotNotify((IDatapoolEquivalenceClass)ec, targetEquivalenceClassIndex);			
		}

		// notify listeners
	    Object[] listeners = listenerList.getListeners();
		for(int i = 0; i < listeners.length; i++)
			((IDatapoolListener)listeners[i]).equivalenceClassMoved(this, sourceEquivalenceClassIndex, targetEquivalenceClassIndex);

	}
	
	/**
	 * Remove the {@link IDatapoolEquivalenceClass equivalence class} at a 
	 * supplied index.
	 * 
	 * @param	equivalenceClassIndex	The equivalence class indsex to remove.
	 * 
	 * @see #updateEquivalenceClass(IDatapoolEquivalenceClass,int)
	 * @see #insertEquivalenceClass(IDatapoolEquivalenceClass,int)
	 * @see #appendEquivalenceClass(IDatapoolEquivalenceClass)
	 * @see #moveEquivalenceClass(int,int)
	 */
	public void removeEquivalenceClass(int equivalenceClassIndex) {
		this.removeEquivalenceClassDoNotNotify(equivalenceClassIndex);
		
		//notify listeners
		Object[] listeners = listenerList.getListeners();
		for(int i = 0; i < listeners.length; i++)
			((IDatapoolListener)listeners[i]).equivalenceClassRemoved(this, equivalenceClassIndex);
	}
	
	/**
	 * Helper function
	 * Remove the {@link IDatapoolEquivalenceClass equivalence class} at a 
	 * supplied index. Do not notify listeners.
	 * 
	 * @param	equivalenceClassIndex	The equivalence class indsex to remove.
	 * 
	 */
	protected void removeEquivalenceClassDoNotNotify(int equivalenceClassIndex) {
		this.getEquivalenceClasses().remove(equivalenceClassIndex);
	}	

	//************************************************************
	// These methods provide support for listeners monitoring actions
	// being performed against a datapool.
	//************************************************************

	/**
	 * Register a listener for actions against the datapool that modify
	 * the data or structure of the data model.  The listener is informed
	 * when variables and records are added or deleted, and when the contents 
	 * of a cell are changed.
	 * 
	 * @see IDatapoolListener
	 */
	public void addDatapoolListener(IDatapoolListener listener) {
		if(listener != null)
		    this.listenerList.add(listener);
	}

	/**
	 * Returns the first listener on the listeners list from the datapool instance (convenience method)
	 * 
	 * @see IDatapoolListener
	 */
	public IDatapoolListener getDatapoolListener() {
	    Object[] listeners = listenerList.getListeners();
	    if(listeners.length > 0)
	        return (IDatapoolListener)listeners[0];
	    
	    return null;
	}
	
	/**
	 * Returns current listeners from the datapool instance (convenience method)
	 * 
	 * @see IDatapoolListener
	 */
	public IDatapoolListener[] getDatapoolListeners() {
	    Object[] listeners = listenerList.getListeners();
	    IDatapoolListener[] dpListeners = new IDatapoolListener[listeners.length];
	    for(int i = 0; i < listeners.length; i++)
	        dpListeners[i] = (IDatapoolListener)listeners[i];
	    
	    return dpListeners;
	}

	/**
	 * Removes a listener from the datapool instance.
	 * 
	 * @see IDatapoolListener
	 */
	public void removeDatapoolListener(IDatapoolListener listener) {
	    if(listener != null)
		    this.listenerList.remove(listener);
	}

	//org.eclipse.hyades.execution.runtime.datapool.IDatapool methods

	/**
	 * The number of variables available in each record.
	 * 
	 * @return	The number of data variables available in each record.
	 */
	public int getVariableCount() {
		if(this.getDatapoolSpec() == null)
		{
			DPLDatapoolSpec datapoolSpec = Common_DatapoolFactory.eINSTANCE.createDPLDatapoolSpec();
			this.setDatapoolSpec(datapoolSpec);
		}
		return this.getDatapoolSpec().getVariables().size();
	}

	/**
	 * The variable at a specified zero based column index.
	 * A {@link DatapoolException DatapoolException} is thrown if the
	 * specified index is not valid.
	 * 
	 * @param	variableIndex		A zero based variable index.
	 * @return	The variable for the specified zero based index.
	 * 
	 * @see #getVariableIndex(String)
	 */
	public org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable getVariable(int variableIndex) {
		if(this.getDatapoolSpec() == null)
		{
			DPLDatapoolSpec datapoolSpec = Common_DatapoolFactory.eINSTANCE.createDPLDatapoolSpec();
			this.setDatapoolSpec(datapoolSpec);
		}
		return (IDatapoolVariable)(this.getDatapoolSpec().getVariables().get(variableIndex));
	}

	/**
	 * Locates the appropriate index associated with a specific
	 * {@link IDatapoolVariable variable} name.  Users will depend
	 * on this method to determine the appropriate cell to access
	 * within a record given a current record and a variable name.
	 * The <i>current record</i> is typically made available from
	 * an {@link IDatapoolIterator iterator} that is performing an
	 * ordered traversal of the records in a datapool.
	 * 
	 * @param	variableName	The name of the variable associated 
	 *							with the desired cell.
	 * @return	The variable index associated with the specified 
	 *			variableName.
	 * 
	 * @see	#getVariableIndexById(String)
	 */
	public int getVariableIndex(String variableName) {

		ListIterator it = this.getDatapoolSpec().getVariables().listIterator();
		while (it.hasNext()) {

			DPLVariable var = (DPLVariable) it.next();
			if (variableName.equals(var.getName()))
				//return variables.indexOf(var);
				return it.previousIndex();

		}
		return -1;
	}

	/**
	 * Locates the appropriate index associated with a specific
	 * {@link IDatapoolVariable variable} ID.  Users may use
	 * this method to determine the appropriate cell to access
	 * within a record given a current record and a variable ID.
	 * 
	 * @param	variableId	The ID of the variable associated 
	 *						with the desired cell.
	 * @return	The variable index associated with the specified 
	 *			variableId.
	 * 
	 * @see	#getVariableIndex(String)
	 */
	public int getVariableIndexById(String variableId) {
		ListIterator it = this.getDatapoolSpec().getVariables().listIterator();
		while (it.hasNext()) {

			DPLVariable var = (DPLVariable) it.next();
			if (variableId.equals(var.getId()))
				return it.previousIndex();
		}

		return -1;

	}

	//************************************************************
	// These methods provide support for the logical equivalence classes
	// associated with an instance of a datapool.
	//************************************************************

	/**
	 * Returns the number of {@link IDatapoolEquivalenceClass equivalence classes}
	 * associated with a datapool.
	 * 
	 * @return	The number of equivalence classes associated with a datapool.
	 */
	public int getEquivalenceClassCount() {
		return this.getEquivalenceClasses().size();
	}

	/**
	 * Accessor for the {@link IDatapoolEquivalenceClass equivalence class} at the specified
	 * zero based index in the datapool.  If an invalid index is supplied a 
	 * {@link DatapoolException} with an appropriate message is thrown.
	 * 
	 * @return The zero-based index for the desired equivalence class.
	 */
	public org.eclipse.hyades.execution.runtime.datapool.IDatapoolEquivalenceClass getEquivalenceClass
						   (int index) {
		return (org.eclipse.hyades.execution.runtime.datapool.IDatapoolEquivalenceClass) this
			.getEquivalenceClasses().get(index);
	}

	/**
	 * Accessor for the default {@link IDatapoolEquivalenceClass equivalence class}
	 * in the datapool.  If the default equivalence class has not been defined then
	 * a value of <b>-1</b> is returned.
	 * 
	 * @return The zero-based index for the default equivalence class.
	 */
	public int getDefaultEquivalenceClassIndex() {
		return defaultEquivalenceClass;
	}

	/**
	 * Locate an {@link IDatapoolEquivalenceClass equivalence class} by name 
	 * within an instance of a datapool.
	 * 
	 * @return The zero-based index of the equivalence class with the supplied
	 *			equivalenceClassName.
	 * 
	 * @see	#getEquivalenceClassIndexById(String)
	 */
	public int getEquivalenceClassIndex(String equivalenceClassName) {
		ListIterator it = this.getEquivalenceClasses().listIterator();
		while (it.hasNext()) {

			DPLEquivalenceClass ec = (DPLEquivalenceClass) it.next();
			if (equivalenceClassName.equals(ec.getName()))
				return it.previousIndex();
		}
		return -1;
	}

	/**
	 * Locate an {@link IDatapoolEquivalenceClass equivalence class} by ID 
	 * within an instance of a datapool.
	 * 
	 * @return The zero-based index of the equivalence class with the supplied
	 *			equivalenceClassId.
	 * 
	 * @see	#getEquivalenceClassIndex(String)
	 */
	public int getEquivalenceClassIndexById(String equivalenceClassId) {
		ListIterator it = this.getEquivalenceClasses().listIterator();
		while (it.hasNext()) {

			DPLEquivalenceClass ec = (DPLEquivalenceClass) it.next();
			if (equivalenceClassId.equals(ec.getId()))
				return it.previousIndex();

		}
		return -1;
	}

	/**
	 * Convenience method - for testing
	 */
	public void logDatapoolAsStrings() {

		DPLLogImpl.log(
			"Datapool "
				+ this.getName()
				+ " **********************************");
		DPLLogImpl.log("");

		//iterate through variables
		ListIterator varIter = this.getDatapoolSpec().getVariables().listIterator();
		DPLLogImpl.log("Variables: ");
		while (varIter.hasNext()) {
			DPLLogImpl.log("      " + ((DPLVariable) varIter.next()).getName());
		}
		DPLLogImpl.log("");
		//iterate through equivalence classes
		ListIterator ecIter = this.getEquivalenceClasses().listIterator();
		while (ecIter.hasNext()) {

			DPLEquivalenceClass ec = (DPLEquivalenceClass) ecIter.next();
			DPLLogImpl.log("EC: " + ec.getName());
			//iterate through records of this equivalence class
			ListIterator recIter = ec.getRecords().listIterator();
			while (recIter.hasNext()) {
				DPLRecord rec = (DPLRecord) recIter.next();
				//iterace through cells of this record
				ListIterator cellIter = rec.getCells().listIterator();
				while (cellIter.hasNext()) {
					DPLLogImpl.log(
						//"      " + ((DPLCellImpl) cellIter.next()).getStringValue()); //print interpreted values
						"      " + ((DPLCell) cellIter.next()).getValue()); //print uninterpreted values
				}
				DPLLogImpl.log("");
			}
			DPLLogImpl.log("");
		}
		DPLLogImpl.log(
			"End of  "
				+ this.getName()
				+ " **********************************");
		DPLLogImpl.log("");

	}

	/**
	 * Setter for an absolute file pathname of the file the datapool was most recently loaded from.
	 * Used a s akey for datapool caching
	 * @param absoluteFilePathname absolute file pathname of the file the datapool was most recently loaded from.
	 */
	void setAbsoluteFilePathname(String absoluteFilePathname) {
		this.absoluteFilePathname = absoluteFilePathname;
	}

	/**
	 * Nullifies the absolute file pathname of the file the datapool was most recently loaded from.
	 *
	 */
	void unsetAbsoluteFilePathname() {
		this.absoluteFilePathname = null;
	}

	/**
	 * accessor for absolute file pathname of the file the datapool was most recently loaded from.
	 * @return absolute file pathname of the file the datapool was most recently loaded from.
	 */
	String getAbsoluteFilePathname() {
		return this.absoluteFilePathname;
	}
	
	/**
	 * Constructs an empty equivalence class 
	 */
	public IDatapoolEquivalenceClass constructEquivalenceClass()
	{
		IDatapoolEquivalenceClass ec = (IDatapoolEquivalenceClass)Common_DatapoolFactory.eINSTANCE.createDPLEquivalenceClass();
		String name = DatapoolUtil.createUniqueECName(this);
		ec.setName(name);
		return ec;	
	}
	
	/**
	 * Constructs an empty variable 
	 */
	public IDatapoolVariable constructVariable()
	{
		IDatapoolVariable var = (IDatapoolVariable)Common_DatapoolFactory.eINSTANCE.createDPLVariable();
		String name = DatapoolUtil.createUniqueVariableName(this);
		var.setName(name);
		IDatapoolSuggestedType suggestedType = new DatapoolSuggestedTypeImpl();
		suggestedType.setSuggestedType(IDatapoolSuggestedType.TYPE_STRING);
		var.setSuggestedType(suggestedType);
		return var;				
	}

} //DPLDatapoolImpl
