/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DatapoolSuggestedTypeImpl.java,v 1.8 2005/02/16 22:21:15 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.models.common.datapool.impl;

import org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType;

/**
 * @author ahoppe
 * @author psun
 * TODO: Is this class supposed to extend AbstractEnumerator? If so, it is not implemented
 */
public class DatapoolSuggestedTypeImpl implements IDatapoolSuggestedType
{	
 	int suggestedType;
 	String[] enumerationLiterals;           	 
 	String className;
 	
 	
	/**
	 * Define the type associated with a variable in the associated
	 * datapool.
	 * 
	 * @param	type	One of the predefined type formats.
	 * 
	 * @see #TYPE_STRING
	 * @see #TYPE_NUMBER
	 * @see #TYPE_BOOLEAN
	 * @see #TYPE_ENUMERATION
	 * @see #TYPE_COMPLEX
	 * @see	#getSuggestedType()
	 */
	public void setSuggestedType(int type)
	{
		if (type < 0 || type >  TYPE_COMPLEX)
		    throw new org.eclipse.hyades.execution.runtime.datapool.DatapoolException
		       (Messages.getString("DatapoolSuggestedTypeImpl.0"));  //$NON-NLS-1$
		suggestedType = type;
	}

	/**
	 * Defines the set of enumerations literals associated with a
	 * {@link #TYPE_ENUMERATION enumeration} type.  If the
	 * {@link #getSuggestedType() type} is not set to a
	 * {@link #TYPE_ENUMERATION enumeration} type then an 
	 * appropriate <code>DatapoolException</code> is thrown.
	 * 
	 * @param	enumLiterals	The set of enumerations literals associated 
	 *							with a {@link #TYPE_ENUMERATION enumeration}
	 *							type.
	 * 
	 * @see #TYPE_ENUMERATION
	 * @see #getEnumerationLiterals()
	 */
	public void setEnumerationLiterals(String[] enumLiterals)
	{
		if (this.suggestedType != TYPE_ENUMERATION)
			throw new org.eclipse.hyades.execution.runtime.datapool.DatapoolException
			   (Messages.getString("DatapoolSuggestedTypeImpl.1")); //$NON-NLS-1$
	    this.enumerationLiterals = enumLiterals;
	} 
		
		

	/**
	 * Defines the value class name associated with a
	 * variable.
	 * 
	 * @param	complexClassName	The complex class name associated 
	 * 								with a variable
	 * 
	 * @see #getSuggestedClassName()
	 */
	public void setSuggestedClassName(String complexClassName)
	{
		this.className = complexClassName;
	}

 	
 	
 	
	/**
	 * One of the predefined type formats:
	 * <ul>
	 * <li>{@link #TYPE_STRING}
	 * <li>{@link #TYPE_NUMBER}
	 * <li>{@link #TYPE_BOOLEAN}
	 * <li>{@link #TYPE_ENUMERATION}
	 * <li>{@link #TYPE_COMPLEX}
	 * </ul>
	 * 
	 * @return	One of the predefined type values.
	 * 
	 * @see #TYPE_STRING
	 * @see #TYPE_NUMBER
	 * @see #TYPE_BOOLEAN
	 * @see #TYPE_ENUMERATION
	 * @see #TYPE_COMPLEX
	 */
	public int getSuggestedType()
	{
		return this.suggestedType;
	}
	
	/**
	 * Returns the display string for the specified suggested type.
	 * 
	 * @param type One of the predefined types:
	 * <ul>
	 * <li>{@link #TYPE_STRING}
	 * <li>{@link #TYPE_NUMBER}
	 * <li>{@link #TYPE_BOOLEAN}
	 * <li>{@link #TYPE_ENUMERATION}
	 * <li>{@link #TYPE_COMPLEX}
	 * </ul>
	 * 
	 * @return a display string representing the specified suggested type.
	 * 
	 * @see #TYPE_STRING
	 * @see #TYPE_NUMBER
	 * @see #TYPE_BOOLEAN
	 * @see #TYPE_ENUMERATION
	 * @see #TYPE_COMPLEX
	 */
	public String getDisplayString(int type)
	{
	    switch(type)
	    {
	        case TYPE_STRING:
	            return TYPE_DISPLAY_STRING;
	        case TYPE_NUMBER:
	            return TYPE_DISPLAY_NUMBER;
	        case TYPE_BOOLEAN:
	            return TYPE_DISPLAY_BOOLEAN;
	        case TYPE_ENUMERATION:
	            return TYPE_DISPLAY_ENUMERATION;
	        case TYPE_COMPLEX:
	            return TYPE_DISPLAY_COMPLEX;
	        default:
	            return TYPE_DISPLAY_STRING;
	    }
	}

	/**
	 * The set of enumerations literals associated with a
	 * {@link #TYPE_ENUMERATION enumeration} type.  If the
	 * {@link #getSuggestedType() type} is not set to 
	 * {@link #TYPE_ENUMERATION enumeration} type then an 
	 * appropriate <code>DatapoolException</code> is thrown.
	 * 
	 * @return	The set of enumerations literals associated with a
	 *			{@link #TYPE_ENUMERATION enumeration} type.
	 * 
	 * @see #TYPE_ENUMERATION
	 */
	public String[] getEnumerationLiterals()
	{
		return this.enumerationLiterals;
	}

	/**
	 * The value class name associated with a variable.
	 * 
	 * @return	The value class name associated with a
	 *			variable.
	 * 
	 */
	public String getSuggestedClassName()
	{
	    if(className == null)
	        className = getDisplayString(suggestedType);
		return className;
	}

}
