/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IDecision.java,v 1.3 2005/02/16 22:21:15 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

/**
 * 
 * A decision is a type of action that allows different blocks to be invoked 
 * based upon evaluation of a condition.
 * 
 * @author jtoomey
 * @author serge
 * @author marcelop
 * @author psun
 * @since 0.0.1
 * 
 */
public interface IDecision extends IAction {

	/**
	 * Returns the condition that is to determine the execution path.
	 * 
	 * @return ICondition
	 */	
	public ICondition getCondition();

	/**
	 * Returns the block to be executed when the condition evaluates to <code>true</code>.
	 * 
	 * @return ICondition
	 */	
	public IBlock getSuccessBlock();
	
	/**
	 * Returns the block to be executed when the condition evaluates to <code>false</code>.
	 * 
	 * @return ICondition
	 */	
	public IBlock getFailureBlock();
}