/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ILoop.java,v 1.3 2005/02/16 22:21:15 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

/**
 * 
 * A loop is an action that allows a block to be repeated under a given 
 * condition.
 * 
 * @author jtoomey
 * @author serge
 * @author marcelop
 * @author psun
 * @since 0.0.1
 */
public interface ILoop extends IAction {

	/**
	 * Returns the condition that is to determine if a block is to be repeated.
	 * 
	 * @return ICondition
	 */
	public ICondition getCondition();
	
	/**
	 * Returns the block that is to be repeated. 
	 * 
	 * @return IBlock
	 */	
	public IBlock getBlock();
}