/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: FacadeResourceFactoryImpl.java,v 1.4 2005/02/16 22:21:15 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

/**
 * @author jtoomey
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class FacadeResourceFactoryImpl extends XMIResourceFactoryImpl {
	/**
 	* The default enconding for XML and XMI files. 
 	*/
	public final static String ENCODING = "UTF-8";

	/**
	 * File extension for the test suite resources
	 */
	public final static String TEST_SUITE_FILE_EXTENSION = "testsuite";

	public final static String PERSISTENCE_ID = "HyadesFacadeResource";
	
	/**
	 * 
	 */
	public FacadeResourceFactoryImpl() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl#createResource(org.eclipse.emf.common.util.URI)
	 */
	public Resource createResource(URI arg0) {
		FacadeResourceImpl resource = new FacadeResourceImpl(arg0);
		resource.setUseZip(true);
		resource.setEncoding(ENCODING);
		return resource;
	}

}
