/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BVRInteractionOperand.java,v 1.10 2005/03/28 21:51:32 jptoomey Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.fragments;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>BVR Interaction Operand</b></em>'.
 * @extends IBlock
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * An InteractionOperand is contained in a CombinedFragment. An InteractionOperand represent one operand of the
 * expression given by the enclosing CombinedFragment.
 * 
 * An InteractionOperand is an InteractionFragment with an optional guard expression. An InteractionOperand may
 * be guarded by a InteractionConstraint. Only InteractionOperands with a guard that evaluates to true at this point in
 * the interaction will be considered for the enclosing CombinedFragment.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.BVRInteractionOperand#getInteractionFragments <em>Interaction Fragments</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.BVRInteractionOperand#getInteractionConstraint <em>Interaction Constraint</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.BVRInteractionOperand#getCombinedFragment <em>Combined Fragment</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage#getBVRInteractionOperand()
 * @model 
 * @generated
 */
public interface BVRInteractionOperand extends BVRInteractionFragment, IBlock{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "";

	/**
	 * Returns the value of the '<em><b>Interaction Fragments</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Interaction Fragments</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Interaction Fragments</em>' containment reference list.
	 * @see org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage#getBVRInteractionOperand_InteractionFragments()
	 * @model type="org.eclipse.hyades.models.common.interactions.BVRInteractionFragment" containment="true" required="true"
	 * @generated
	 */
	EList getInteractionFragments();

	/**
	 * Returns the value of the '<em><b>Interaction Constraint</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Interaction Constraint</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Interaction Constraint</em>' containment reference.
	 * @see #setInteractionConstraint(BVRInteractionConstraint)
	 * @see org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage#getBVRInteractionOperand_InteractionConstraint()
	 * @model containment="true"
	 * @generated
	 */
	BVRInteractionConstraint getInteractionConstraint();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.fragments.BVRInteractionOperand#getInteractionConstraint <em>Interaction Constraint</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Interaction Constraint</em>' containment reference.
	 * @see #getInteractionConstraint()
	 * @generated
	 */
	void setInteractionConstraint(BVRInteractionConstraint value);

	/**
	 * Returns the value of the '<em><b>Combined Fragment</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.fragments.BVRCombinedFragment#getInteractionOperands <em>Interaction Operands</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Combined Fragment</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Combined Fragment</em>' container reference.
	 * @see #setCombinedFragment(BVRCombinedFragment)
	 * @see org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage#getBVRInteractionOperand_CombinedFragment()
	 * @see org.eclipse.hyades.models.common.fragments.BVRCombinedFragment#getInteractionOperands
	 * @model opposite="interactionOperands"
	 * @generated
	 */
	BVRCombinedFragment getCombinedFragment();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.fragments.BVRInteractionOperand#getCombinedFragment <em>Combined Fragment</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Combined Fragment</em>' container reference.
	 * @see #getCombinedFragment()
	 * @generated
	 */
	void setCombinedFragment(BVRCombinedFragment value);

} // BVRInteractionOperand
