/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BVRLifeline.java,v 1.9 2005/03/28 21:51:32 jptoomey Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.interactions;

import org.eclipse.emf.common.util.EList;

import org.eclipse.hyades.models.common.common.CMNNamedElement;

import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.fragments.BVRPartDecomposition;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>BVR Lifeline</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A lifeline represents an individual participant in the Interaction. Participants represents instances of Deployable.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVRLifeline#getInteractionFragments <em>Interaction Fragments</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVRLifeline#getInstances <em>Instances</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVRLifeline#getPartDecomposition <em>Part Decomposition</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVRLifeline#getInteraction <em>Interaction</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRLifeline()
 * @model 
 * @generated
 */
public interface BVRLifeline extends CMNNamedElement{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "";

	/**
	 * Returns the value of the '<em><b>Interaction Fragments</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getLifelines <em>Lifelines</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Interaction Fragments</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Interaction Fragments</em>' reference list.
	 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRLifeline_InteractionFragments()
	 * @see org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getLifelines
	 * @model type="org.eclipse.hyades.models.common.interactions.BVRInteractionFragment" opposite="lifelines"
	 * @generated
	 */
	EList getInteractionFragments();

	/**
	 * Returns the value of the '<em><b>Instances</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.configuration.CFGInstance}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.configuration.CFGInstance#getLifeline <em>Lifeline</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Instances</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Instances</em>' reference list.
	 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRLifeline_Instances()
	 * @see org.eclipse.hyades.models.common.configuration.CFGInstance#getLifeline
	 * @model type="org.eclipse.hyades.models.common.configuration.CFGInstance" opposite="lifeline" required="true"
	 * @generated
	 */
	EList getInstances();

	/**
	 * Returns the value of the '<em><b>Part Decomposition</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Part Decomposition</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Part Decomposition</em>' reference.
	 * @see #setPartDecomposition(BVRPartDecomposition)
	 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRLifeline_PartDecomposition()
	 * @model 
	 * @generated
	 */
	BVRPartDecomposition getPartDecomposition();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.interactions.BVRLifeline#getPartDecomposition <em>Part Decomposition</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Part Decomposition</em>' reference.
	 * @see #getPartDecomposition()
	 * @generated
	 */
	void setPartDecomposition(BVRPartDecomposition value);

	/**
	 * Returns the value of the '<em><b>Interaction</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.fragments.BVRInteraction#getLifelines <em>Lifelines</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Interaction</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Interaction</em>' container reference.
	 * @see #setInteraction(BVRInteraction)
	 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRLifeline_Interaction()
	 * @see org.eclipse.hyades.models.common.fragments.BVRInteraction#getLifelines
	 * @model opposite="lifelines" required="true"
	 * @generated
	 */
	BVRInteraction getInteraction();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.interactions.BVRLifeline#getInteraction <em>Interaction</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Interaction</em>' container reference.
	 * @see #getInteraction()
	 * @generated
	 */
	void setInteraction(BVRInteraction value);

} // BVRLifeline
