/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BVRMessage.java,v 1.9 2005/03/28 21:51:32 jptoomey Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.interactions;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.models.common.configuration.CFGOperation;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>BVR Message</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * A Message defines a particular communication between Lifelines of an Interaction.
 * 
 * A Message defines one specific kind of communication in an Interaction. A communication can be e.g. raising a signal, invoking an operation, creating or destroying an instance. The Message specifies not only the kind of communication given by the dispatching ExecutionOccurrence, but also the sender and the receiver.
 * A Message associates normally two EventOccurrences - one sending EventOccurrence and one receiving Event-Occurrence.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVRMessage#getMessageSort <em>Message Sort</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVRMessage#getReceiveMessageEnd <em>Receive Message End</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVRMessage#getSendMessageEnd <em>Send Message End</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVRMessage#getInteractionFragment <em>Interaction Fragment</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVRMessage#getInstanceValues <em>Instance Values</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVRMessage#getOperation <em>Operation</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRMessage()
 * @model 
 * @generated
 */
public interface BVRMessage extends EObject{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String copyright = "";

	/**
	 * Returns the value of the '<em><b>Message Sort</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.hyades.models.common.interactions.BVRMessageSort}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Message Sort</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Message Sort</em>' attribute.
	 * @see org.eclipse.hyades.models.common.interactions.BVRMessageSort
	 * @see #setMessageSort(BVRMessageSort)
	 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRMessage_MessageSort()
	 * @model 
	 * @generated
	 */
	BVRMessageSort getMessageSort();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.interactions.BVRMessage#getMessageSort <em>Message Sort</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Message Sort</em>' attribute.
	 * @see org.eclipse.hyades.models.common.interactions.BVRMessageSort
	 * @see #getMessageSort()
	 * @generated
	 */
	void setMessageSort(BVRMessageSort value);

	/**
	 * Returns the value of the '<em><b>Receive Message End</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.interactions.BVRMessageEnd#getReceiveMessage <em>Receive Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Receive Message End</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Receive Message End</em>' reference.
	 * @see #setReceiveMessageEnd(BVRMessageEnd)
	 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRMessage_ReceiveMessageEnd()
	 * @see org.eclipse.hyades.models.common.interactions.BVRMessageEnd#getReceiveMessage
	 * @model opposite="receiveMessage" required="true"
	 * @generated
	 */
	BVRMessageEnd getReceiveMessageEnd();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.interactions.BVRMessage#getReceiveMessageEnd <em>Receive Message End</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Receive Message End</em>' reference.
	 * @see #getReceiveMessageEnd()
	 * @generated
	 */
	void setReceiveMessageEnd(BVRMessageEnd value);

	/**
	 * Returns the value of the '<em><b>Send Message End</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.interactions.BVRMessageEnd#getSendMessage <em>Send Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Send Message End</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Send Message End</em>' reference.
	 * @see #setSendMessageEnd(BVRMessageEnd)
	 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRMessage_SendMessageEnd()
	 * @see org.eclipse.hyades.models.common.interactions.BVRMessageEnd#getSendMessage
	 * @model opposite="sendMessage" required="true"
	 * @generated
	 */
	BVRMessageEnd getSendMessageEnd();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.interactions.BVRMessage#getSendMessageEnd <em>Send Message End</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Send Message End</em>' reference.
	 * @see #getSendMessageEnd()
	 * @generated
	 */
	void setSendMessageEnd(BVRMessageEnd value);

	/**
	 * Returns the value of the '<em><b>Interaction Fragment</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getMessages <em>Messages</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Interaction Fragment</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Interaction Fragment</em>' container reference.
	 * @see #setInteractionFragment(BVRInteractionFragment)
	 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRMessage_InteractionFragment()
	 * @see org.eclipse.hyades.models.common.interactions.BVRInteractionFragment#getMessages
	 * @model opposite="messages" required="true"
	 * @generated
	 */
	BVRInteractionFragment getInteractionFragment();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.interactions.BVRMessage#getInteractionFragment <em>Interaction Fragment</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Interaction Fragment</em>' container reference.
	 * @see #getInteractionFragment()
	 * @generated
	 */
	void setInteractionFragment(BVRInteractionFragment value);

	/**
	 * Returns the value of the '<em><b>Instance Values</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.common.testprofile.TPFInstanceValue}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Instance Values</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Instance Values</em>' reference list.
	 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRMessage_InstanceValues()
	 * @model type="org.eclipse.hyades.models.common.testprofile.TPFInstanceValue"
	 * @generated
	 */
	EList getInstanceValues();

	/**
	 * Returns the value of the '<em><b>Operation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Operation</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Operation</em>' reference.
	 * @see #setOperation(CFGOperation)
	 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVRMessage_Operation()
	 * @model 
	 * @generated
	 */
	CFGOperation getOperation();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.common.interactions.BVRMessage#getOperation <em>Operation</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Operation</em>' reference.
	 * @see #getOperation()
	 * @generated
	 */
	void setOperation(CFGOperation value);

} // BVRMessage
