/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TPFExecutionEventImpl.java,v 1.14 2005/03/28 21:51:31 jptoomey Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.impl;

import java.util.Collection;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.common.CMNAnnotation;
import org.eclipse.hyades.models.common.common.CMNDefaultProperty;

import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;

import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.EObjectReference;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TPF Execution Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getOwnerId <em>Owner Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getTimestamp <em>Timestamp</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getText <em>Text</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getEventType <em>Event Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getExecutionHistory <em>Execution History</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getInteractionFragment <em>Interaction Fragment</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getChildren <em>Children</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getParent <em>Parent</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getProperties <em>Properties</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getAnnotations <em>Annotations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFExecutionEventImpl#getEObjectReferences <em>EObject References</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TPFExecutionEventImpl extends CMNNamedElementImpl implements TPFExecutionEvent
{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The default value of the '{@link #getOwnerId() <em>Owner Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwnerId()
	 * @generated
	 * @ordered
	 */
	protected static final String OWNER_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getOwnerId() <em>Owner Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwnerId()
	 * @generated
	 * @ordered
	 */
	protected String ownerId = OWNER_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected static final long TIMESTAMP_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected long timestamp = TIMESTAMP_EDEFAULT;

	/**
	 * The default value of the '{@link #getText() <em>Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getText()
	 * @generated
	 * @ordered
	 */
	protected static final String TEXT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getText() <em>Text</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getText()
	 * @generated
	 * @ordered
	 */
	protected String text = TEXT_EDEFAULT;

	/**
	 * The default value of the '{@link #getEventType() <em>Event Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEventType()
	 * @generated
	 * @ordered
	 */
	protected static final String EVENT_TYPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getEventType() <em>Event Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEventType()
	 * @generated
	 * @ordered
	 */
	protected String eventType = EVENT_TYPE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getInteractionFragment() <em>Interaction Fragment</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInteractionFragment()
	 * @generated
	 * @ordered
	 */
	protected BVRInteractionFragment interactionFragment = null;

	/**
	 * The cached value of the '{@link #getChildren() <em>Children</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChildren()
	 * @generated
	 * @ordered
	 */
	protected EList children = null;

	/**
	 * The cached value of the '{@link #getProperties() <em>Properties</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProperties()
	 * @generated
	 * @ordered
	 */
	protected EList properties = null;

	/**
	 * The cached value of the '{@link #getAnnotations() <em>Annotations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnnotations()
	 * @generated
	 * @ordered
	 */
	protected EList annotations = null;

	/**
	 * The cached value of the '{@link #getEObjectReferences() <em>EObject References</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEObjectReferences()
	 * @generated
	 * @ordered
	 */
	protected EList eObjectReferences = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected TPFExecutionEventImpl()
	{
		super();
		id = new Guid().toString();
		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return Common_TestprofilePackage.eINSTANCE.getTPFExecutionEvent();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getOwnerId() {
		return ownerId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOwnerId(String newOwnerId) {
		String oldOwnerId = ownerId;
		ownerId = newOwnerId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__OWNER_ID, oldOwnerId, ownerId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getTimestamp() {
		return timestamp;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTimestamp(long newTimestamp) {
		long oldTimestamp = timestamp;
		timestamp = newTimestamp;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__TIMESTAMP, oldTimestamp, timestamp));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getText() {
		return text;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setText(String newText) {
		String oldText = text;
		text = newText;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__TEXT, oldText, text));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getEventType() {
		return eventType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEventType(String newEventType) {
		String oldEventType = eventType;
		eventType = newEventType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__EVENT_TYPE, oldEventType, eventType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFExecutionHistory getExecutionHistory() {
		if (eContainerFeatureID != Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY) return null;
		return (TPFExecutionHistory)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExecutionHistory(TPFExecutionHistory newExecutionHistory) {
		if (newExecutionHistory != eContainer || (eContainerFeatureID != Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY && newExecutionHistory != null)) {
			if (EcoreUtil.isAncestor(this, newExecutionHistory))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newExecutionHistory != null)
				msgs = ((InternalEObject)newExecutionHistory).eInverseAdd(this, Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_EVENTS, TPFExecutionHistory.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newExecutionHistory, Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY, newExecutionHistory, newExecutionHistory));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRInteractionFragment getInteractionFragment() {
		if (interactionFragment != null && interactionFragment.eIsProxy()) {
			BVRInteractionFragment oldInteractionFragment = interactionFragment;
			interactionFragment = (BVRInteractionFragment)eResolveProxy((InternalEObject)interactionFragment);
			if (interactionFragment != oldInteractionFragment) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_TestprofilePackage.TPF_EXECUTION_EVENT__INTERACTION_FRAGMENT, oldInteractionFragment, interactionFragment));
			}
		}
		return interactionFragment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BVRInteractionFragment basicGetInteractionFragment() {
		return interactionFragment;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInteractionFragment(BVRInteractionFragment newInteractionFragment) {
		BVRInteractionFragment oldInteractionFragment = interactionFragment;
		interactionFragment = newInteractionFragment;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__INTERACTION_FRAGMENT, oldInteractionFragment, interactionFragment));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getChildren() {
		if (children == null) {
			children = new EObjectContainmentWithInverseEList(TPFExecutionEvent.class, this, Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN, Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT);
		}
		return children;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFExecutionEvent getParent() {
		if (eContainerFeatureID != Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT) return null;
		return (TPFExecutionEvent)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParent(TPFExecutionEvent newParent) {
		if (newParent != eContainer || (eContainerFeatureID != Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT && newParent != null)) {
			if (EcoreUtil.isAncestor(this, newParent))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newParent != null)
				msgs = ((InternalEObject)newParent).eInverseAdd(this, Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN, TPFExecutionEvent.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newParent, Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT, newParent, newParent));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getProperties() {
		if (properties == null) {
			properties = new EObjectContainmentEList(CMNDefaultProperty.class, this, Common_TestprofilePackage.TPF_EXECUTION_EVENT__PROPERTIES);
		}
		return properties;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getAnnotations() {
		if (annotations == null) {
			annotations = new EObjectContainmentEList(CMNAnnotation.class, this, Common_TestprofilePackage.TPF_EXECUTION_EVENT__ANNOTATIONS);
		}
		return annotations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getEObjectReferences() {
		if (eObjectReferences == null) {
			eObjectReferences = new EObjectContainmentEList(EObjectReference.class, this, Common_TestprofilePackage.TPF_EXECUTION_EVENT__EOBJECT_REFERENCES);
		}
		return eObjectReferences;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY, msgs);
				case Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN:
					return ((InternalEList)getChildren()).basicAdd(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY:
					return eBasicSetContainer(null, Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY, msgs);
				case Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN:
					return ((InternalEList)getChildren()).basicRemove(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT:
					return eBasicSetContainer(null, Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT, msgs);
				case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PROPERTIES:
					return ((InternalEList)getProperties()).basicRemove(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_EXECUTION_EVENT__ANNOTATIONS:
					return ((InternalEList)getAnnotations()).basicRemove(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EOBJECT_REFERENCES:
					return ((InternalEList)getEObjectReferences()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_EVENTS, TPFExecutionHistory.class, msgs);
				case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN, TPFExecutionEvent.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__ID:
				return getId();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__DESCRIPTION:
				return getDescription();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__NAME:
				return getName();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__OWNER_ID:
				return getOwnerId();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TIMESTAMP:
				return new Long(getTimestamp());
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TEXT:
				return getText();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EVENT_TYPE:
				return getEventType();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY:
				return getExecutionHistory();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__INTERACTION_FRAGMENT:
				if (resolve) return getInteractionFragment();
				return basicGetInteractionFragment();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN:
				return getChildren();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT:
				return getParent();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PROPERTIES:
				return getProperties();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__ANNOTATIONS:
				return getAnnotations();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EOBJECT_REFERENCES:
				return getEObjectReferences();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__ID:
				setId((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__NAME:
				setName((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__OWNER_ID:
				setOwnerId((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TIMESTAMP:
				setTimestamp(((Long)newValue).longValue());
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TEXT:
				setText((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EVENT_TYPE:
				setEventType((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY:
				setExecutionHistory((TPFExecutionHistory)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__INTERACTION_FRAGMENT:
				setInteractionFragment((BVRInteractionFragment)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN:
				getChildren().clear();
				getChildren().addAll((Collection)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT:
				setParent((TPFExecutionEvent)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PROPERTIES:
				getProperties().clear();
				getProperties().addAll((Collection)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__ANNOTATIONS:
				getAnnotations().clear();
				getAnnotations().addAll((Collection)newValue);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EOBJECT_REFERENCES:
				getEObjectReferences().clear();
				getEObjectReferences().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__ID:
				setId(ID_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__NAME:
				setName(NAME_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__OWNER_ID:
				setOwnerId(OWNER_ID_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TIMESTAMP:
				setTimestamp(TIMESTAMP_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TEXT:
				setText(TEXT_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EVENT_TYPE:
				setEventType(EVENT_TYPE_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY:
				setExecutionHistory((TPFExecutionHistory)null);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__INTERACTION_FRAGMENT:
				setInteractionFragment((BVRInteractionFragment)null);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN:
				getChildren().clear();
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT:
				setParent((TPFExecutionEvent)null);
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PROPERTIES:
				getProperties().clear();
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__ANNOTATIONS:
				getAnnotations().clear();
				return;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EOBJECT_REFERENCES:
				getEObjectReferences().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__OWNER_ID:
				return OWNER_ID_EDEFAULT == null ? ownerId != null : !OWNER_ID_EDEFAULT.equals(ownerId);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TIMESTAMP:
				return timestamp != TIMESTAMP_EDEFAULT;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__TEXT:
				return TEXT_EDEFAULT == null ? text != null : !TEXT_EDEFAULT.equals(text);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EVENT_TYPE:
				return EVENT_TYPE_EDEFAULT == null ? eventType != null : !EVENT_TYPE_EDEFAULT.equals(eventType);
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EXECUTION_HISTORY:
				return getExecutionHistory() != null;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__INTERACTION_FRAGMENT:
				return interactionFragment != null;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN:
				return children != null && !children.isEmpty();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PARENT:
				return getParent() != null;
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__PROPERTIES:
				return properties != null && !properties.isEmpty();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__ANNOTATIONS:
				return annotations != null && !annotations.isEmpty();
			case Common_TestprofilePackage.TPF_EXECUTION_EVENT__EOBJECT_REFERENCES:
				return eObjectReferences != null && !eObjectReferences.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (ownerId: ");
		result.append(ownerId);
		result.append(", timestamp: ");
		result.append(timestamp);
		result.append(", text: ");
		result.append(text);
		result.append(", eventType: ");
		result.append(eventType);
		result.append(')');
		return result.toString();
	}

	/**
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class adapter)
	{
		return Platform.getAdapterManager().getAdapter(this, adapter);
	}
} //TPFExecutionEventImpl
