/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LoopDetailPage.java,v 1.4 2005/02/16 22:21:42 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.common.internal.editor;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;

/**
 * @author marcelop
 * @since 1.0.2
 */
abstract public class LoopDetailPage 
extends DetailSection.DetailPage implements ModifyListener, SelectionListener
{
	protected static final int HELP_PAGE_CONTROL = 1;
	protected static final int HELP_ITERATION_CONTROL = 2;
	protected static final int HELP_SYNCHRONOUS_CONTROL = 3;

	private Button synchronousButton;
	private StyledText iteractionsText;
	
	private ILoop loop;
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		loop = null;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection.DetailPage#createControl(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
	 */
	public Control createControl(Composite parent, FormWidgetFactory factory)
	{
		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		Composite composite = widgetFactory.createComposite(parent);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(GridDataUtil.createFill());

		synchronousButton = widgetFactory.createButton(composite, getSynchronousLabel(), SWT.CHECK);
		synchronousButton.setLayoutData(GridDataUtil.createHorizontalFill());

		widgetFactory.createLabel(composite, getIteractionsLabel());
		iteractionsText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE);
		iteractionsText.setLayoutData(GridDataUtil.createHorizontalFill());
		
		widgetFactory.paintBordersFor(composite);
		
		registerHelp(HELP_PAGE_CONTROL, composite);				
		registerHelp(HELP_ITERATION_CONTROL, iteractionsText);				
		registerHelp(HELP_SYNCHRONOUS_CONTROL, synchronousButton);				
		
		return composite;
	}
	
	abstract protected String getSynchronousLabel();
	abstract protected String getIteractionsLabel();
	
	protected void registerHelp(int flag, Object object)
	{
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#setInput(java.lang.Object)
	 */
	public void setInput(Object object)
	{
		loop = null;

		synchronousButton.removeSelectionListener(this);
		iteractionsText.removeVerifyKeyListener(this);
		iteractionsText.removeModifyListener(this);

		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)object;
			if(structuredSelection.size() == 1)
				object = structuredSelection.getFirstElement();
		}

		if(object instanceof ILoop)
		{
			loop = (ILoop)object;
			
			String value = loop.getCondition().getConstraint();
			if(value != null)
				iteractionsText.setText(value);
			else
				iteractionsText.setText("");

			synchronousButton.setSelection(loop.isSynchronous());
			iteractionsText.setEditable(true);			
		}
		else
		{
			synchronousButton.setEnabled(false);
			iteractionsText.setText("");
		}
		
		synchronousButton.addSelectionListener(this);
		iteractionsText.addVerifyKeyListener(this);
		iteractionsText.addModifyListener(this);
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection#getInput()
	 */
	public Object getInput()
	{
		return loop;
	}

	/**
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e)
	{
		e.doit = !isReadOnly();
	}

	/**
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e)
	{
		if(isReadOnly())
		{
			e.doit = false;
		}
		else
		{
			if(e.widget == synchronousButton)
			{
				loop.setSynchronous(synchronousButton.getSelection());
				getEditorForm().getBaseEditorExtension().markDirty();
			}
		}		
	}	
	
	/**
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	public void modifyText(ModifyEvent e)
	{
		if(e.widget == iteractionsText)
		{
			loop.getCondition().setConstraint(iteractionsText.getText());
			getEditorForm().getBaseEditorExtension().markDirty();
		}
	}

	/**
	 * @see org.eclipse.swt.custom.VerifyKeyListener#verifyKey(org.eclipse.swt.events.VerifyEvent)
	 */
	public void verifyKey(VerifyEvent event)
	{
		super.verifyKey(event);
		UIUtil.integerStyledTextVerifyKey(event);
	}
}
