/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AddTestInvocation.java,v 1.3 2005/02/16 22:21:42 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.common.internal.editor.action;

import java.util.Iterator;

import org.eclipse.jface.dialogs.IDialogConstants;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;

import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.test.common.TestCommonImages;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.common.internal.dialog.InvokedTestSelectionDialog;
import org.eclipse.hyades.test.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.common.internal.util.TestCommonUtil;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;

/**
 * Adds a loop to the block.
 * @author marcelop
 * @since 0.3.0
 */
abstract public class AddTestInvocation 
extends AddBlockChildAction
{
	/**
	 * Constructor for AddTestMethod
	 */
	public AddTestInvocation(IITestSuiteProvider testSuiteProvider, String baseName)
	{
		super(testSuiteProvider, TestCommonPlugin.getString("W_EVT_INV"), baseName);
		setImageDescriptor(TestCommonImages.INSTANCE.getImageDescriptor(TestCommonImages.IMG_INVOCATION));
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);

		InvokedTestSelectionDialog selectionDialog = createInvokedTestSelectionDialog(getTestSuite());
		if(selectionDialog.open() == IDialogConstants.OK_ID)
		{
			for (Iterator i = selectionDialog.getTests().iterator(); i.hasNext();)
			{
				ITest test = (ITest)i.next();
				ResourceSet resourceSet = ((EObject)getTestSuite()).eResource().getResourceSet();
				test = (ITest)EMFUtil.getEObject(resourceSet, (EObject)test, true);
	
				ITestInvocation testInvocation = HyadesFactory.INSTANCE.createTestInvocation(test);
				testInvocation.setName(calculateName(test));
				getBlock().getActions().add(testInvocation);
			}
			setActionPerformed(true);
		}
	}
	
	abstract protected InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite testSuite);
	
	protected String calculateName(ITest test)
	{
		String testName = test.getName();
		if(testName == null)
			return TestCommonUtil.getUniqueName(getBaseName(), getBlock().getActions());
			
		if(test instanceof ITestCase)
		{
			ITestSuite invokedTestSuite = ((ITestCase)test).getOwner();
			if(getTestSuite() != invokedTestSuite)
			{ 
				String testSuiteName = invokedTestSuite.getName();
				if(testSuiteName != null)
					testName = testSuiteName + "." + testName;
			} 
		}
		
		return TestCommonPlugin.getString("NME_CONCAT_SEP", new String[]{testName, getBaseName()});
	}
}
