/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: IExecutionEnvironment.java,v 1.4 2005/02/16 22:20:05 qiyanli Exp $

Contributors:
 IBM Corporation - initial implementation
 IBM Rational - initial implementation
	SCAPA Technologies - initial implementation
**********************************************************************/

package org.eclipse.hyades.execution.core;

/** 
 * 
 * IExecutionEnvironment is a specialized IExecutionComponent that has
 * knowledge about the environment that the IExecutionComponent's and
 * its children reside within.
 * @version 0.0.2
 */
public interface IExecutionEnvironment extends IExecutionComponent {
	
	/** Get the entire environment as it is currently set.
	 * 
	 * @exception ExecutionComponentStateException 
	 * @return an array of IOrderedProperty objects
	 */
	public IOrderedProperty[] getEnv() throws ExecutionComponentStateException;
	
	/**
	 * Get the environment variable by name.
	 * @param name The name of the IOrderedProperty to lookup.
	 * @return the IOrderedProperty if it exists, <code>null</code> otherwise
	 */
	public IOrderedProperty getEnvByName(String name) throws ExecutionComponentStateException; 
	
	/** Set the entire environment, overwriting an existing properties.
	 * 
	 * @exception ExecutionComponentStateException 
	 * @param env An array of IOrderedProperty objects to set the environment 
	 */
	public void setEnv(IOrderedProperty[] env) throws ExecutionComponentStateException;
	
	/** Set the single environment variable, overwriting the existing property.
	 * 
	 * @exception ExecutionComponentStateException 
	 * @param env The IOrderedProperty object to set the environment 
	 */
	public void setEnv(IOrderedProperty env) throws ExecutionComponentStateException;

	/** Add a property from the currently set environment.  This does not check for
	 * like named properties.
	 * @exception ExecutionComponentStateException 
	 * @param env The property to add
	 */
	public void addEnv(IOrderedProperty env) throws ExecutionComponentStateException;
	
	/** Remove a property from the currently set environment
	 * 
	 * @exception ExecutionComponentStateException 
	 * @param name The name of the property to remove
	 */
	public IOrderedProperty removeProperty(String name) throws ExecutionComponentStateException;
}
