/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: INode.java,v 1.4 2005/02/16 22:20:05 qiyanli Exp $

Contributors:
 IBM Corporation - initial implementation
 IBM Rational - initial implementation
	SCAPA Technologies - initial implementation
**********************************************************************/

package org.eclipse.hyades.execution.core;



import java.security.Principal;

/**
 *
 * A INode instance identifies a physical entity on the network.  At the 
 * most abstract level, INodes are named entities you can create a ISession
 * with.  Depending upon the network communication mechanism, the INode is
 * extended to capture the details of the communication mechanism.  
 * @version 0.0.2
 * 
 */
public interface INode {
	
	/**
	 * Gets the name of the INode.
	 * @return the name
	 */
	public String getName();
	
	/**
	 * Open a session with the daemon.
	 * 
	 * The specifics of this method are currently unresolved.  It is expected 
	 * that we will add an IConnection interface that will probably replace
	 * this method.  Whatever methods take the place of this method are 
	 * expected to throw a number of exception types.  
	 * 
	 * RKD:  We need to specialize Principal to handle logins automatically
	 * within the framework.
	 * 
	 * @param daemonType <b>UNRESOLVED</b> - it's unclear if this is the right place
	 * for this extension point.
	 * @param principal A specialized Principal object for authentication and
	 * login.
	 * @return an ISession on this INode
	 */
	public ISession connect(String daemonType, Principal principal) throws java.net.UnknownHostException, UnknownDaemonException, DaemonConnectException; 

}
