/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IFileLocater.java,v 1.4 2005/02/16 22:20:05 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.core.file;

import java.io.IOException;

/**
 * @author rduggan
 *
 * This interface defines the lowest level of the file transfer mechanism. The intent
 * is to have this interface used on both sides of the connection.  On the server side, 
 * the implementation is told to performa an action on a file. The server will then perform
 * the action, and in the case of file transfer, make the file avalable to be manipulated
 * at the specific IFileLocation.  On the client side, the client requests the appropriate
 * file management operation and in the case of file transfer, is told where it can retrieve 
 * the remote file from.  Keep in mind, all references to the file are provided in terms of 
 * the remote system.  The consumer of the IFileLocation is responsible for any further local
 * operations.  For example, in the file transfer scenario's the consumer of the implementation
 * class is responsible for connecting to the file location and reading the file then persisting
 * it in a local file.
 */
public interface IFileLocater {

	/**
	 * Retrieve a remote file
	 * @param filename - the absolute path of the file to get
	 * @return the details of where the file can be retrieved from
	 */
	public IFileLocation getFile(String filename)throws IOException;
	
	/**
	 * Put a file on a remote system
	 * @param filename the absolute name of the file on the remote system
	 * @return the details of where the file can be written to 
	 */
	public IFileLocation putFile(String filename)throws IOException;
	
	/**
	 * Delete a file on a remote system.
	 * @param filename the absolute name of the file on the remote system
	 */
	public void deleteFile(String filename)throws IOException;
}
