/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IFileManager.java,v 1.6 2005/02/16 22:20:08 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.core.file;

import java.io.IOException;


/**
 * @author Giridhar.S
 * 
 * The interface implemented by classes which provide methods for performing file transfer. 
 *
 */
public interface IFileManager {
	
	/**
	 * Method to request Agent Controller to send the named file.
	 * @param localName - where to put it on the client side.
	 * @param remoteName - remote file name
	 * 
	 */
	public /*int*/ void getFile (String localName, String remoteName) throws IOException;
	
	/**
	 * Method to send a file to the Agent Controller machine.
	 * @param localName - where to find the file.
	 * @param remoteName -  where to put the file.
	 **/
	public /*int*/ void putFile (String localName, String remoteName) throws IOException;
	
	/**
	 * Method to delete the named file
	 * @param absFileName - name of the file.
	 */
	public void deleteFile (String absFileName)  throws IOException;
	
}
