/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Invoker.java,v 1.4 2005/02/16 22:20:14 qiyanli Exp $
 * 
 * Contributors: 
 * IBM Rational - Initial implementation
 **********************************************************************/
package org.eclipse.hyades.execution.invocation;

import java.lang.reflect.Method;

/**
 * This class knows how to invoke a specified method call on a specified object.
 * Invocation in our scheme is done on the remote side, so this class is loaded
 * on the remote agent; and the execution of its methods are local to that agent.
 */
public class Invoker {
	
	/**
	 * Look up the appropriate method, invoke it and wrap the result in a
	 * <code>ReturnData</code> instance.
	 * 
	 * @param callData
	 * @return
	 */
	public static ReturnData invoke(CallData callData){
		Object methodRtnVal = null;
		try {
			Object target = callData.getTarget();
			Method method = target.getClass().getMethod(
				callData.getCall(), callData.getArgTypes());
			methodRtnVal = method.invoke(target, callData.getCallArgs());
		}
		catch (Throwable t ) {
			methodRtnVal = t;
		}
		return new ReturnData(callData.getTargetId(), callData.getArgTypes(), callData.getCall(), methodRtnVal);
	}

}
