/********************************************************************** 
 * Copyright (c) 2005 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: AbstractFileInspectionCommand.java,v 1.2 2005/05/05 19:52:37 sschneid Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.internal.execution.core.file;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended.Cookie;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended.FileIdentifierList;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended.Option;

/**
 * A superclass to all file inspection commands, file inspection command are
 * file server commands that operate on one set of files on the side of the file
 * server.
 * 
 * @author Scott E. Schneider
 */
abstract class AbstractFileInspectionCommand extends AbstractFileServerCommand implements IFileInspectionCommand {

    /**
     * Remote identifiers qualify files on the remote file server side, this
     * files are used in this particular command
     */
    private final FileIdentifierList remoteIdentifiers;

    /**
     * Construct an abstract file inspection command, used by subclasses only
     * 
     * @param identity
     *            the class of the command, used in the server state for loading
     * @param cookie
     *            cookie to identify the state of this particular command, its
     *            up to the particular command to decide how to use this cookie,
     *            it is stored in the file server command base class
     * @param remoteIdentifiers
     *            the remote identifiers identifying the files on the remote
     *            side for operation on
     * @param monitor
     *            the progress monitor to use for status query and cancelability
     */
    AbstractFileInspectionCommand(Class identity, Cookie cookie, FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) {
        super(identity, cookie, Option.NONE, monitor);
        this.remoteIdentifiers = remoteIdentifiers;
    }

    abstract class Client extends AbstractFileServerCommand.Client {

        Client(ISocketChannel channel) {
            super(channel);
        }

    }

    abstract class Server extends AbstractFileServerCommand.Server {

        Server(ISocketChannel channel) {
            super(channel);
        }

    }

}