/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others. All rights reserved. This
 * program and the accompanying materials are made available under the terms of
 * the Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html $Id:
 * AbstractFileManipulationCommand.java,v 1.1 2005/05/03 14:32:54 sschneid Exp $
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/

package org.eclipse.hyades.internal.execution.core.file;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended.Cookie;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended.FileIdentifierList;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended.Option;

abstract class AbstractFileManipulationCommand extends AbstractFileServerCommand implements IFileManipulationCommand {

    FileIdentifierList remoteIdentifiers;

    AbstractFileManipulationCommand(Class identity, Cookie cookie, IProgressMonitor monitor) {
        super(identity, cookie, Option.NONE, monitor);
        this.remoteIdentifiers = null; // need to derive from given cookie
    }

    AbstractFileManipulationCommand(Class identity, FileIdentifierList remoteIdentifiers, IProgressMonitor monitor) {
        super(identity, Cookie.NONE, Option.NONE, monitor);
        this.remoteIdentifiers = remoteIdentifiers;
    }

    AbstractFileManipulationCommand(Class identity) {
        super(identity);
    }

    abstract class Client extends AbstractFileServerCommand.Client {

        Client(ISocketChannel channel) {
            super(channel);
        }

    }

    abstract class Server extends AbstractFileServerCommand.Server {

        Server(ISocketChannel channel) {
            super(channel);
        }

    }

}