/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others. All rights reserved. This
 * program and the accompanying materials are made available under the terms of
 * the Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html $Id:
 * AbstractFileTransferCommand.java,v 1.1 2005/05/03 14:32:54 sschneid Exp $
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/

package org.eclipse.hyades.internal.execution.core.file;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended.Cookie;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended.FileIdentifierList;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended.Option;

abstract class AbstractFileTransferCommand extends AbstractFileServerCommand implements IFileTransferCommand {

    FileIdentifierList localIdentifiers, remoteIdentifiers;

    AbstractFileTransferCommand(Class identity) {
        super(identity);
    }

    AbstractFileTransferCommand(Class identity, Cookie cookie, FileIdentifierList localIdentifiers,
            FileIdentifierList remoteIdentifiers, Option[] options, IProgressMonitor monitor) {
        super(identity, cookie, options, monitor);
        this.localIdentifiers = localIdentifiers;
        this.remoteIdentifiers = remoteIdentifiers;
    }

    abstract class Client extends AbstractFileServerCommand.Client {

        Client(ISocketChannel channel) {
            super(channel);
        }

    }

    abstract class Server extends AbstractFileServerCommand.Server {

        Server(ISocketChannel channel) {
            super(channel);
        }

    }

}