/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others. All rights reserved. This
 * program and the accompanying materials are made available under the terms of
 * the Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html $Id:
 * IFileServerCommandFactory.java,v 1.1 2005/05/03 14:32:54 sschneid Exp $
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/

package org.eclipse.hyades.internal.execution.core.file;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended.Cookie;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended.FileIdentifierList;
import org.eclipse.hyades.execution.core.file.IFileManagerExtended.Option;

public interface IFileServerCommandFactory {
    IGetFileCommand createGetFileCommand(FileIdentifierList localIdentifiers, FileIdentifierList remoteIdentifiers,
            Option[] options, IProgressMonitor monitor);

    IPutFileCommand createPutFileCommand(Cookie cookie, FileIdentifierList localIdentifiers, FileIdentifierList remoteIdentifiers,
            Option[] options, IProgressMonitor monitor);

    IDeleteFileCommand createDeleteFileCommand(Cookie cookie, IProgressMonitor monitor);

    IDeleteFileCommand createDeleteFileCommand(FileIdentifierList remoteIdentifiers, IProgressMonitor monitor);

    IModifyPermissionCommand createModifyPermissionCommand(FileIdentifierList remoteIdentifiers, String permissionDirective,
            IProgressMonitor monitor);

    IListContentCommand createListContentCommand(FileIdentifierList remoteIdentifiers, IProgressMonitor monitor);

    IQueryServerStatusCommand createQueryServerStatusCommand();

    IFileServerCommand createFileServerCommand(String identity, ISocketChannel clientChannel)
            throws InvalidFileServerCommandException;

}