/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISocketChannelFactory.java,v 1.1 2005/05/05 19:52:37 sschneid Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.internal.execution.core.file;

import java.io.IOException;
import java.net.Socket;

/**
 * @author Scott E. Schneider
 */
public interface ISocketChannelFactory {
    /**
     * Creates a local socket channel abstraction for the given standard channel
     * 
     * @param realChannel
     *            the standard Java abstraction
     * @return the local socket channel interface
     */
    public ISocketChannel create(java.nio.channels.SocketChannel realChannel);

    /**
     * Creates a local socket channel abstraction for the given socket
     * 
     * @param socket
     *            the socket to seed this socket channel
     * @return
     */
    public ISocketChannel create(Socket socket) throws IOException;
}