/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SocketChannelFactory.java,v 1.1 2005/05/05 19:52:37 sschneid Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.internal.execution.core.file;

import java.io.IOException;
import java.net.Socket;

/**
 * Factory to create the local socket channel abstraction
 * 
 * @author Scott E. Schneider
 */
public class SocketChannelFactory implements ISocketChannelFactory {

    /**
     * The singleton file manager factory instance
     */
    private static final ISocketChannelFactory factory;

    /**
     * Create and store the singleton instance, not using on demand creation,
     * always create on class load
     */
    static {
        factory = new SocketChannelFactory();
    }

    /**
     * Singleton accessor method
     * 
     * @return
     */
    public static ISocketChannelFactory getInstance() {
        return SocketChannelFactory.factory;
    }

    /**
     * Limit instantiation to same class for singleton pattern
     */
    private SocketChannelFactory() {
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.hyades.internal.execution.core.file.ISocketChannelFactory#create(java.nio.channels.SocketChannel)
     */
    public ISocketChannel create(java.nio.channels.SocketChannel realChannel) {
        return new SocketChannel(realChannel);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.hyades.internal.execution.core.file.ISocketChannelFactory#create(java.net.Socket)
     */
    public ISocketChannel create(Socket socket) throws IOException {
        return new SocketChannel(socket);
    }

}