/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: IHyadesTest.java,v 1.4 2005/02/16 22:21:35 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.junit;

import junit.framework.Test;

/**
 * This interface defines an extended API to the {@link junit.framework.Test} interface 
 * that enforces that all implementors are a JUnit compliant Test with additional 
 * information regarding the parent Test, the current iteration and the name of the Test.
 * 
 * @author marcelop
 * @since 1.0.1
 */
public interface IHyadesTest
extends Test
{
	/**
	 * Sets the test id
	 * @return this test
	 */
	public IHyadesTest setId(String id);

	/**
	 * Returns the id of the test
	 */ 
	public String getId();

	/**
	 * Sets the parent of this test.
	 * @param parent
	 */
	public void setParent(Test parent);
	
	/**
	 * Returns the parent of this test.
	 * @return Test
	 */
	public Test getParent();

	/**
	 * Sets the test invocation id.
	 * @param testInvocationId
	 * @return this test
	 */
	public IHyadesTest setTestInvocationId(String testInvocationId);

	/**
	 * Gets the test invocation id.
	 * @return String
	 */
	public String getTestInvocationId();

	/**
	 * Returns the current iteration of the test or -1 if the iteration cannot be
	 * calculated.
	 * @return int
	 */
	public int getIteration();
	
	/**
	 * Returns the name of the test.
	 * @return String
	 */ 
	public String getName();
	
	/**
	 * Returns the default JUnit toString value.
	 * @return String
	 */
	public String toJUnitString();
	
	/**
	 * Sets wheter this test must be executed synchronously or 
	 * asynchronously.
	 * @param synchronous
	 * @return this test
	 */
	public IHyadesTest setSynchronous(boolean synchronous);
	
	/**
	 * Returns whether this test is synchronous or asynchronous.
	 * @return boolean
	 */
	public boolean isSynchronous();
	
	
	/**
	 * Sets whether this test implements a loop
	 * @param loop
	 * @return this test
	 */
	public IHyadesTest setLoop(boolean loop);
	
	/**
	 * Returns whether or not this test implements a loop.
	 * @return boolean
	 */
	public boolean isLoop();
}
