/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SnapshotObservationBase.java,v 1.5 2005/02/16 22:21:26 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.loaders.statistical;

import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDView;
import org.eclipse.hyades.model.statistical.StatisticalFactory;

/**
 * @author slavescu
 */
public abstract class SnapshotObservationBase extends IgnoredXMLFragmentLoader {
	protected static final String time = "time";
	protected static final String memberDescriptor = "memberDescriptor";
	protected Double fTime;
	protected String fMemberDescriptor;
	protected SDMemberDescriptor mMemberDescriptor;
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#addAttribute(java.lang.String, java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		switch (LoadersUtils.getHashCode(name)) {
			case StatisticalConstants.time_int :
				fTime = Double.valueOf(value);
				break;
			case StatisticalConstants.memberDescriptor_int :
				fMemberDescriptor = value;
				break;
			default :
				super.addAttribute(name, value);
		}
	}
	protected void updateAttributes(SDSnapshotObservation observation) {
		observation.getCreationTime().add(fTime);
		SDSampleWindow sampleWindow = getSampleWindow();
		if(!sampleWindow.getObservations().contains(observation))
		{
			sampleWindow.getObservations().add(observation);
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#addYourselfInContext()
	 */
	public void addYourselfInContext() {
		try {
			mMemberDescriptor = (SDMemberDescriptor)LookupServiceExtensions.getInstance().locate(context,SDDescriptor.class, fMemberDescriptor);
		} catch (Exception e) {
		}
	}
	
	/**
	 * @return
	 */
	private SDSampleWindow getSampleWindow() {
		SDView view = (SDView)context.getAgent().getView();
		SDSampleWindow sampleWindow = null;
		if(view==null)
		{	
			view = StatisticalFactory.eINSTANCE.createSDView();
			context.getAgent().setView(view);
			sampleWindow = StatisticalFactory.eINSTANCE.createSDSampleWindow();
			sampleWindow.setView(view);
			
		}
		//TODO: MS add support for multiple windows 
		sampleWindow = (SDSampleWindow)view.getWindow().get(0);
		if(sampleWindow==null)
		{
			sampleWindow = StatisticalFactory.eINSTANCE.createSDSampleWindow();
			sampleWindow.setView(view);
		}
		return sampleWindow;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String elementName) {
		super.initialize(context, elementName);
		fTime = null;
		fMemberDescriptor = null;
	}
}
