/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: StatisticalLookupService.java,v 1.6 2005/02/16 22:21:26 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.statistical;

import java.util.Map;
import org.eclipse.hyades.loaders.util.GenericLookupService;
import org.eclipse.hyades.model.statistical.SDDescriptor;
/**
 * @author slavescu
 */
public class StatisticalLookupService extends GenericLookupService {
	//~ Constructors
	// -------------------------------------------------------------------------------

	public StatisticalLookupService() {
		super();
		types.add(SDDescriptor.class);
//		types.add(SDSampleDescriptorImpl.class);
//		types.add(SDCounterDescriptorImpl.class);
	}

	//~ Methods
	// ------------------------------------------------------------------------------------

	protected boolean doProcessObject(
		Map typeMap,
		Class type,
		Object object,
		boolean remove) {
		if (object == null) {
			return false;
		}
		if(object instanceof SDDescriptor)
		{	
				addOrRemove(
					typeMap,
					((SDDescriptor) object).getId(),
					object,
					remove);

				return true;
		}
		
		return false;
	}
	
	protected Class getEquivalentClass(Class type) {
		if(SDDescriptor.class.isAssignableFrom(type))
			return SDDescriptor.class;
		return type;
	}
	
}
