/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SDGaugeRepresentationImpl.java,v 1.11 2005/02/16 22:21:26 qiyanli Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.model.statistical.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.model.statistical.SDGaugeRepresentation;
import org.eclipse.hyades.model.statistical.SDMemberDescriptor;
import org.eclipse.hyades.model.statistical.StatisticalPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>SD Gauge Representation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.model.statistical.impl.SDGaugeRepresentationImpl#getMaxThreshold <em>Max Threshold</em>}</li>
 *   <li>{@link org.eclipse.hyades.model.statistical.impl.SDGaugeRepresentationImpl#getMinThreshold <em>Min Threshold</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SDGaugeRepresentationImpl extends SDRangeRepresentationImpl implements SDGaugeRepresentation {
	/**
	 * The default value of the '{@link #getMaxThreshold() <em>Max Threshold</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaxThreshold()
	 * @generated
	 * @ordered
	 */
	protected static final int MAX_THRESHOLD_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getMaxThreshold() <em>Max Threshold</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaxThreshold()
	 * @generated
	 * @ordered
	 */
	protected int maxThreshold = MAX_THRESHOLD_EDEFAULT;

	/**
	 * The default value of the '{@link #getMinThreshold() <em>Min Threshold</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMinThreshold()
	 * @generated
	 * @ordered
	 */
	protected static final int MIN_THRESHOLD_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getMinThreshold() <em>Min Threshold</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMinThreshold()
	 * @generated
	 * @ordered
	 */
	protected int minThreshold = MIN_THRESHOLD_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SDGaugeRepresentationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return StatisticalPackage.eINSTANCE.getSDGaugeRepresentation();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getMaxThreshold() {
		return maxThreshold;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMaxThreshold(int newMaxThreshold) {
		int oldMaxThreshold = maxThreshold;
		maxThreshold = newMaxThreshold;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, StatisticalPackage.SD_GAUGE_REPRESENTATION__MAX_THRESHOLD, oldMaxThreshold, maxThreshold));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getMinThreshold() {
		return minThreshold;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMinThreshold(int newMinThreshold) {
		int oldMinThreshold = minThreshold;
		minThreshold = newMinThreshold;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, StatisticalPackage.SD_GAUGE_REPRESENTATION__MIN_THRESHOLD, oldMinThreshold, minThreshold));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case StatisticalPackage.SD_GAUGE_REPRESENTATION__MEMBER_DESCRIPTOR:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, StatisticalPackage.SD_GAUGE_REPRESENTATION__MEMBER_DESCRIPTOR, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case StatisticalPackage.SD_GAUGE_REPRESENTATION__MEMBER_DESCRIPTOR:
					return eBasicSetContainer(null, StatisticalPackage.SD_GAUGE_REPRESENTATION__MEMBER_DESCRIPTOR, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case StatisticalPackage.SD_GAUGE_REPRESENTATION__MEMBER_DESCRIPTOR:
					return ((InternalEObject)eContainer).eInverseRemove(this, StatisticalPackage.SD_MEMBER_DESCRIPTOR__REPRESENTATION, SDMemberDescriptor.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case StatisticalPackage.SD_GAUGE_REPRESENTATION__MEMBER_DESCRIPTOR:
				return getMemberDescriptor();
			case StatisticalPackage.SD_GAUGE_REPRESENTATION__MIN:
				return new Integer(getMin());
			case StatisticalPackage.SD_GAUGE_REPRESENTATION__MAX:
				return new Integer(getMax());
			case StatisticalPackage.SD_GAUGE_REPRESENTATION__MAX_THRESHOLD:
				return new Integer(getMaxThreshold());
			case StatisticalPackage.SD_GAUGE_REPRESENTATION__MIN_THRESHOLD:
				return new Integer(getMinThreshold());
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case StatisticalPackage.SD_GAUGE_REPRESENTATION__MEMBER_DESCRIPTOR:
				setMemberDescriptor((SDMemberDescriptor)newValue);
				return;
			case StatisticalPackage.SD_GAUGE_REPRESENTATION__MIN:
				setMin(((Integer)newValue).intValue());
				return;
			case StatisticalPackage.SD_GAUGE_REPRESENTATION__MAX:
				setMax(((Integer)newValue).intValue());
				return;
			case StatisticalPackage.SD_GAUGE_REPRESENTATION__MAX_THRESHOLD:
				setMaxThreshold(((Integer)newValue).intValue());
				return;
			case StatisticalPackage.SD_GAUGE_REPRESENTATION__MIN_THRESHOLD:
				setMinThreshold(((Integer)newValue).intValue());
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case StatisticalPackage.SD_GAUGE_REPRESENTATION__MEMBER_DESCRIPTOR:
				setMemberDescriptor((SDMemberDescriptor)null);
				return;
			case StatisticalPackage.SD_GAUGE_REPRESENTATION__MIN:
				setMin(MIN_EDEFAULT);
				return;
			case StatisticalPackage.SD_GAUGE_REPRESENTATION__MAX:
				setMax(MAX_EDEFAULT);
				return;
			case StatisticalPackage.SD_GAUGE_REPRESENTATION__MAX_THRESHOLD:
				setMaxThreshold(MAX_THRESHOLD_EDEFAULT);
				return;
			case StatisticalPackage.SD_GAUGE_REPRESENTATION__MIN_THRESHOLD:
				setMinThreshold(MIN_THRESHOLD_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case StatisticalPackage.SD_GAUGE_REPRESENTATION__MEMBER_DESCRIPTOR:
				return getMemberDescriptor() != null;
			case StatisticalPackage.SD_GAUGE_REPRESENTATION__MIN:
				return min != MIN_EDEFAULT;
			case StatisticalPackage.SD_GAUGE_REPRESENTATION__MAX:
				return max != MAX_EDEFAULT;
			case StatisticalPackage.SD_GAUGE_REPRESENTATION__MAX_THRESHOLD:
				return maxThreshold != MAX_THRESHOLD_EDEFAULT;
			case StatisticalPackage.SD_GAUGE_REPRESENTATION__MIN_THRESHOLD:
				return minThreshold != MIN_THRESHOLD_EDEFAULT;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (maxThreshold: ");
		result.append(maxThreshold);
		result.append(", minThreshold: ");
		result.append(minThreshold);
		result.append(')');
		return result.toString();
	}

} //SDGaugeRepresentationImpl
