/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon.jboss.internal;

import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.common.internal.CommonModuleTrace;
import org.eclipse.hyades.perfmon.utils.internal.SetVariableCommand;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConInterface;


public class JBossModuleTrace extends CommonModuleTrace {

	String reg_host_name = null;
	
	public JBossModuleTrace(StatConInterface statcon, String rac_host, String port, String jbossHost, URI smodelpath, URI monitor_uri) {
		super();
		
		//create the initial commands to pass to our agent
		SetVariableCommand[] reg_commands = new SetVariableCommand[] {
				new SetVariableCommand(JBossConstants.JBOSS_HOST,jbossHost),				
				new SetVariableCommand(JBossConstants.PORT,port)				
			};
		
		init(	statcon,
				rac_host,
				"JBossAgent",
				JBossConstants.AGENT_PREFIX,
				" ("+rac_host+")",
				PerfmonPlugin.getString("JBOSS_AGENT"),
				reg_commands,
				smodelpath,
				monitor_uri
				);
		
		//
		// we can register any specialist actions here
		//
	}
}