/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon.perfmon.internal;

import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.perfmon.common.internal.CommonModuleTrace;
import org.eclipse.hyades.perfmon.utils.internal.SetVariableCommand;
import org.eclipse.hyades.statistical.ui.editor.internal.StatConInterface;


public class PerfmonModuleTrace extends CommonModuleTrace {

	String reg_host_name = null;
	
	public PerfmonModuleTrace(StatConInterface statcon, String rac_host, String reg_host, URI smodelpath, URI monitor_uri) {
		super();
		
		//reg_host == rac_host means no remote registry
		if (reg_host.equalsIgnoreCase(rac_host)) {
			reg_host = "null";	
		}

		//get the name of the registry host
		String reg_host_name = reg_host;

		if (reg_host_name.equalsIgnoreCase("null")) {
			reg_host_name = rac_host;	
		} else {
			if (!reg_host.startsWith("\\\\")) {
				reg_host_name = reg_host;
				reg_host = "\\\\" + reg_host;	
			} else {
				reg_host_name = reg_host.substring(2);
			}
		}

		//create the initial commands to pass to our agent
		SetVariableCommand[] reg_commands = new SetVariableCommand[] {
			new SetVariableCommand(PerfmonConstants.VARNAME_REMOTE_REG_HOST,reg_host),
		};
		
		init(	statcon,
				rac_host,
				"PerfmonAgent",
				PerfmonConstants.AGENT_PREFIX,
				reg_host_name+" ("+rac_host+")",
				PerfmonPlugin.getString("PERFMON_AGENT"),
				reg_commands,
				smodelpath,
				monitor_uri
				);
		
		//
		// we can register any specialist actions here
		//
	}
}