/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon.utils.internal;

import java.io.IOException;
import java.util.List;

import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.SetNVPairCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.perfmon.PerfmonPlugin;

public class DCAgentCommandUtil {
Agent agent;	
Process process;
Node node;
	public DCAgentCommandUtil(Agent agent) throws InactiveProcessException {
		this.agent = agent;
		process = agent.getProcess();
		node = process.getNode();
	}
	
//	public void setFrequency(int freq) throws IOException {
//		setNVPair("var_int", "DC_WAITTIME", ""+freq);
//	}
	public void getUpdatedTree() throws IOException {
		setNVPair("updatetree", "", "true");
	}		

	public void getUpdatedTree(SDDescriptor update) throws IOException {
		if (update.getId() == null) return;
		PerfmonPlugin.DBG.info("Requesting tree update for descriptor "+update.getName()+" ("+update.getId()+")");
		setNVPair("updatetree", update.getId(), "true");
	}
	
	public void setVariable(SetVariableCommand command) throws IOException {
		PerfmonPlugin.DBG.info("Setting "+command.type+" var "+command.name+" to "+command.value);
		setNVPair(command.type,command.name,command.value);
	}

	public void stopTracing(SDDescriptor counter) throws IOException, NullPointerException {
		//turn off it and its children
		applyDown(counter,false);
		//turn off its parents
//		applyUp(counter,false);
	}
	public void startTracing(SDDescriptor counter) throws IOException, NullPointerException {
		//turn on it and its children
		applyDown(counter,true);
		//turn on its parents
		applyUp(counter,true);
	}
	private void apply(SDDescriptor descriptor, boolean on) throws IOException {
		traceCounter(descriptor,on);
	}
	private void applyUp(SDDescriptor descriptor, boolean on) throws IOException {
		SDDescriptor parent = descriptor.getParent();
		if (parent != null) {
			apply(parent,on);
			applyUp(parent,on);					
		}	
	}
	private void applyDown(SDDescriptor descriptor, boolean on) throws IOException {
		apply(descriptor,on);
		List children = descriptor.getChildren();
		for (int i = 0; i < children.size(); i++) {
			applyDown((SDDescriptor)children.get(i),on);
		}
	}
	
	private void traceCounter(SDDescriptor counter,boolean on) throws IOException, NullPointerException {
		String id = counter.getId();
		if (id == null) throw new NullPointerException("descriptor ID not found");
		setNVPair("filter", id, ""+on);
	}

	public void setNVPair(String type, String name, String value) throws IOException {
		
		ControlMessage message=new ControlMessage();
		SetNVPairCommand command=new SetNVPairCommand();
		try {
			command.setProcessId(Long.parseLong(process.getProcessId()));
		}
		catch(InactiveProcessException e) {
			throw new IOException("Inactive process - try again soon?");
		}
		command.setAgentName(agent.getName());
		command.setType(type);
		command.setName(name);
		command.setValue(value);
		message.appendCommand(command);
		try {
			node.getConnection().sendMessage(message, null);
		} catch(IOException e) {
			//log errors?
			throw e;
		}
	}
}