/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.perfmon.utils.internal;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.model.statistical.SDDescriptor;
import org.eclipse.hyades.model.statistical.SDSampleWindow;
import org.eclipse.hyades.model.statistical.SDSnapshotObservation;
import org.eclipse.hyades.model.statistical.SDView;
import org.eclipse.hyades.model.statistical.StatisticalFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.ProcessAdapter;
import org.eclipse.swt.widgets.Display;

public class DCAgentGenericLoader implements DataProcessor, ProcessListener, AgentListener {

private static final boolean PRINTXML = false;	
private boolean LOGXML = false;	
	
StatisticalFactory factory = StatisticalFactory.eINSTANCE;

DCAgentCommandUtil command = null;

long started;
String tracename;

String process_exe;

Node node;
Process process;
Agent agent;

TRCAgent trcagent;

boolean running = false;

XMLLoader xloader;
ArrayList listeners = new ArrayList();
ModelListener adapter = new ModelListener();

OutputStream logfile;
IProgressMonitor pmonitor;

	public DCAgentGenericLoader(IProgressMonitor pmonitor, long started, TRCAgent tagent, String modelname, String process_exe, String host, int port, SetVariableCommand[] commands, int freq) throws Exception {
		this.pmonitor = pmonitor;
		this.started = started;
		this.process_exe = process_exe;
		init(modelname,tagent,host,port,commands,freq);
	}
	public DCAgentGenericLoader(long started, TRCAgent tagent, String modelname, String process_exe, String host, SetVariableCommand[] commands, int freq) throws Exception {
		this.started = started;
		this.process_exe = process_exe;
		init(modelname,tagent,host,10002,commands,freq);
	}

	public void processLaunched(Process process) {
		//do nothing
	}
	public void processExited(Process process) {
		if (trcagent == null) {
			return;
		}
		TRCAgentProxy agentProxy = trcagent.getAgentProxy();
        if (agentProxy == null) { 
            return; 
        } 
		
		TRCProcessProxy processProxy = trcagent.getAgentProxy().getProcessProxy();
		if (processProxy == null) { 
            return; 
        } 
        
        agentProxy.setActive(false); 
        agentProxy.setAttached(false); 
        agentProxy.setMonitored(false); 
        processProxy.setActive(false); 

//        giveControl(agentProxy, true, false); 
        
        final TRCAgentProxy agentTemp = agentProxy; 

        Display d = Display.getDefault(); 

        d.asyncExec(new Runnable() { 
                public void run() { 
                    //update ui 
                    ProfileEvent event = UIPlugin.getDefault().getProfileEvent(); 

                    event.setSource(agentTemp); 
                    event.setType(ProfileEvent.STOP_MONITOR); 
                    UIPlugin.getDefault().notifyProfileEventListener(event); 
                } 
            }); 
	}
	
	public void agentActive(Agent agent) {
	}
	public void agentInactive(Agent agent) {
		processExited(process);
	}
	public void error(Agent agent, String errorId, String errorMessage) {
	}
	public void handleCommand(Agent agent, CommandElement command) {
	}
	
	public DCAgentCommandUtil getCommandUtil() {
		return command;
	}
	
	public void killProcess() throws Exception {
//		agent.getProcess().kill(0);
		node.killProcess(process);
	}

	public SDDescriptor getModel() {
		EList models = trcagent.getDescriptor();
		if (models.size() > 0) { 
			return (SDDescriptor)models.get(0);
		} else {
			return null;	
		}
	}
	
	public void addLoaderListener(StatisticalLoaderListener listener) {
		listeners.add(listener);
	}

	public void removeLoaderListener(StatisticalLoaderListener listener) {
		listeners.add(listener);
	}


	private Agent findAgent(Node node) throws NotConnectedException {
		Agent agent = null;
		Enumeration processes = node.listProcesses();
		
		//
		// Search for an existing agent
		//
		while (processes.hasMoreElements()) {
			Process p = (Process)processes.nextElement();
			PerfmonPlugin.DBG.info("checking RAC process "+p.getName());
			agent = findAgent(p);

			if (agent != null) {
				break;
			}
		}
		
		return agent;
	}

	private Agent findAgent(Process p) {
		if (p == null) return null;
		
		Enumeration agents = p.listAgents();

		Agent the_agent = null;

		if (!agents.hasMoreElements()) {
			PerfmonPlugin.DBG.info("found no agents in this process");
		}
		
		while (agents.hasMoreElements()) {
			Agent a = (Agent)agents.nextElement();

			PerfmonPlugin.DBG.info("found RAC agent "+a.getName()+"/"+a.getType() + " looking for "+process_exe);

			if (a.getName().startsWith(process_exe)
			||	a.getType().startsWith(process_exe)) {
			    
				
				try {
//					String agentname = a.getName();
//					agentname = agentname.substring(agentname.indexOf("#")+1);

					if (!a.isAttached()) {
						process = p;
						the_agent = a;
						PerfmonPlugin.DBG.info("agent called "+a.getName()+" not attached - accepting");
//						long t = Long.parseLong(agentname); 
//						process = p;
//						agent = a;
						break;
					}
				} catch (Exception e) {
					PerfmonPlugin.DBG.warning("error checking agent "+e);
				}
				
			}
		}
		return the_agent;
	}

	private void init(String modelname, TRCAgent trcagent, String host, int port, SetVariableCommand[] commands, int freq) throws Exception {
		
		this.trcagent = trcagent;

		SDView view = (SDView)trcagent.getView();

		//create a view if none exists
		if (view == null) {
			view = factory.createSDView();
			view.setAgent(trcagent);
			view.setName("view");
		}
		
		//create a sample window if none exists
		if (view.eContents().size() == 0) {
			SDSampleWindow window = factory.createSDSampleWindow();
			window.setView(view);
		}
	
		//add EMF listeners to the agent and the all the sample windows (should catch adds for descriptors and observations)
		trcagent.getAgentProxy().eAdapters().add(adapter);
		trcagent.eAdapters().add(adapter);
		trcagent.getView().eAdapters().add(adapter);
		
		EList windows = view.eContents();
		for (int k = 0; k < windows.size(); k++) {
			SDSampleWindow window = (SDSampleWindow)windows.get(k);
			window.eAdapters().add(adapter);
		}


if (LOGXML) {
	try {
		logfile = new FileOutputStream("C:\\temp\\XMLLOG.txt");
	} catch (Throwable t) {}
}
				
		tracename = modelname;

		xloader = new XMLLoader(trcagent);		

		PerfmonPlugin.DBG.warning("asked to connect to "+host+":"+port);

		try {
			PerfmonPlugin.DBG.info("connecting to RAC");
			
			// Bug # 93555
            node = PDCoreUtil.profileConnect(host, String.valueOf(port));
			//node = NodeFactory.createNode(host);			
			
			if (pmonitor != null) pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_CONNECTING"));
			//node.connect(port);

			PerfmonPlugin.DBG.info("connected to RAC");

			if (pmonitor != null) pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_CREATING"));

			//
			// Find an agent
			//			
			agent = findAgent(node); 
			
			//
			// No agent found, try to launch one
			//			
			if (agent == null) {
				PerfmonPlugin.DBG.info("Launching RAC PerfmonAgent");
				Process process = ProcessFactory.createProcess(node,process_exe);
				
				 
		            
				if (process != null) {
					final IProcess adapter = new ProcessAdapter(process, null);
		            process.addProcessListener(new ProcessListener() {
		             
		             public void processLaunched(Process p)
		             {
		             	UIPlugin.getDefault().registerLaunchProcess(adapter);
		             }
		             
		             public void processExited(Process p)
		             {
		             	UIPlugin.getDefault().deregisterLaunchProcess(adapter);
		             }
		            });
		            
		            ProcessLaunch launcher = new ProcessLaunch();
		            launcher.process = process;
		            Display display = Display.getCurrent();
		            if (display == null) display = Display.getDefault();
		            display.syncExec(launcher);
		            
		            if (launcher.error != null) {
		                //Failed to launch the process, rethrow exception
		                throw launcher.error;
		            }
//					process.launch();

					long t = System.currentTimeMillis() + 8000;	//search for a maximum of 25 seconds

					//wait for the process to become active
					while (!process.isActive() && System.currentTimeMillis() < t) {
						try {
							Thread.sleep(200);	
						} catch (Exception e) {
						}
					}

					t = System.currentTimeMillis() + 25000;	//search for a maximum of 25 seconds
//					agent = findAgent(node); 
					agent = findAgent(process); 
					while (agent == null && System.currentTimeMillis() < t) {
						Thread.sleep(1250);
						agent = findAgent(node);
					} 
				}
			}

//			if (agent == null) {
//				PerfmonPlugin.DBG.info("Disconnecting from node and trying to find agent again");
//				node.getConnection().disconnect();
//				node.connect(port);
//				agent = findAgent(node); 
//			}

			//
			// If we now have an agent, 
			//
			if (agent != null) {
				
				command = new DCAgentCommandUtil(agent);
				
				if (pmonitor != null) pmonitor.setTaskName(PerfmonPlugin.getString("PROGRESS_CONFIGURING"));

				agent.addAgentListener(this);
				process.addProcessListener(this);
				
				PerfmonPlugin.DBG.info("attaching to perfmon agent "+agent.getName());

				running = true;

				try {
					trcagent.getAgentProxy().getProcessProxy().setPid(Integer.parseInt(agent.getProcess().getProcessId()));
				} catch (Exception e) {
					PerfmonPlugin.DBG.error("could not set process proxy PID");
				}

				trcagent.getAgentProxy().setRuntimeId(process.getUUID());
				
				LoadersUtils.registerAgentInstance(trcagent.getAgentProxy(),agent);
				
				agent.attach();
				agent.startMonitoring(this);
				trcagent.setRuntimeId(agent.getUUID());

				PerfmonPlugin.DBG.info("attached To & Monitoring Perfmon Agent");
				
				for (int x = 0; x < commands.length; x++) {
					command.setVariable(commands[x]);
				}
				
				command.setVariable(new SetVariableCommand(SetVariableCommand.VAR_FREQUENCY,freq));
				command.getUpdatedTree();
				
				long t = System.currentTimeMillis();
/*				
				while (this.getModel() == null) {
					try {
						Thread.sleep(100);
					} catch (Exception e){}	
					if (System.currentTimeMillis()-t > 10000) {
						t = Long.MAX_VALUE;
						PerfmonPlugin.DBG.info("been waiting 10 seconds and still no model...");
					}
				}
*/								
			} else {
				PerfmonPlugin.DBG.warning("no perfmon agent found");
				throw new Exception(PerfmonPlugin.getString("ERROR_CREATE_PERFMON_AGENT"));
			}
			
		} catch (Exception e) {
			PerfmonPlugin.DBG.warning("problem initialising loader");

//////////////// FOR SAMPLE EVENTS ONLY
//temporarily disabled for sample events
			throw e;
////////////////////////////////////////

		}
	}
	
	class ProcessLaunch implements Runnable{
	    Exception error = null;
		Process process;
		public void run() {
			try {
				process.launch();
			} catch (Exception e) {
			    error = e;
//				PerfmonPlugin.DBG.logVisibleError(e,PerfmonPlugin.getString("ERROR_LAUNCH_PERFMON"),true);
			}
		}
	}
/*
	public void setNVPair(String type, String name, String value) throws IOException {
		
		ControlMessage message=new ControlMessage();
		SetNVPairCommand command=new SetNVPairCommand();
		try {
			command.setProcessId(Long.parseLong(process.getProcessId()));
		}
		catch(InactiveProcessException e) {
			throw new IOException(PerfmonPlugin.getString("ERROR_INACTIVE_PROCESS"));
		}
		command.setAgentName(agent.getName());
		command.setType(type);
		command.setName(name);
		command.setValue(value);
		message.appendCommand(command);
		try {
			node.getConnection().sendMessage(message, null);
		} catch(IOException e) {
			//log errors?
			throw e;
		}
	}
*/
	public boolean isRunning() {
		return running;
	}

	public void shutdown() {
		running = false;
		PerfmonPlugin.DBG.info("shutdown");
		if (agent != null) {
			try {
				PerfmonPlugin.DBG.info("detaching from agent");
				agent.stopMonitoring();
				agent.detach();	
				
			} catch (Exception e) {
				PerfmonPlugin.DBG.warning("failed to detach from agent",e);
			}
		}

	}

	protected void finalize() throws Throwable {
		super.finalize();
		shutdown();
	}

	/////////////////////////////////////////////
	//  DATA PROCESSOR IMPL
	/////////////////////////////////////////////

	public void incoming(String msg) {
		try {
//			logfile.write(msg.getBytes());
		} catch (Throwable t) {
t.printStackTrace();			
			PerfmonPlugin.DBG.warning("unable to parse message "+msg);
		}
	}

	private byte[] stringToBytes(String s) {
		ByteArrayOutputStream bout = new ByteArrayOutputStream();
		for (int i = 0; i < s.length(); i++) {
			bout.write((byte)s.charAt(i));	
		}
		return bout.toByteArray();
	}

boolean first = true;
	public void incommingData(byte[] buffer, int length, java.net.InetAddress peer) {

if (LOGXML) {		
	try {
		logfile.write(buffer,0,length);
	} catch (Throwable t) {
		LOGXML = false;
	}
}
		
		buffer = new String(buffer,0,length).trim().getBytes();
		length = buffer.length;

		if (length == 0) return;

		if (first) {
			byte[] ROOT_START = "<TRACE>".getBytes();
			xloader.loadEvent(ROOT_START,ROOT_START.length);
			first = false;	
		} 

		try {			
//logfile.write(buffer,0,length);
			
if (PRINTXML) System.out.println(new String(buffer,0,length));			
			
			xloader.loadEvent(buffer,length);			
		} catch (Throwable t) {
			PerfmonPlugin.DBG.error("unable to parse message "+new String(buffer,0,30)+"...",t);
		}

//how many fragments has the loader loaded?
//		try {
//			Field field = XMLLoader.class.getDeclaredField("fragmentsCount");
//			field.setAccessible(true);
//			PerfmonPlugin.DBG.info("LOADED FRAGMENTS = "+field.getInt(xloader));
//		} catch (Exception e) {
//			e.printStackTrace();			
//		}

//check the model for changes
//		EList models = trcagent.getDescriptor();
//		for (int i = 0; i < models.size(); i++) {
//			checkModel((SDDescriptor)models.get(i));
//		}
	}

	public void incommingData(char[] buffer, int length, java.net.InetAddress peer) {
		//?
	}


	public void invalidDataType(byte[] data, int length, java.net.InetAddress peer) {
		PerfmonPlugin.DBG.warning("invalid datatype");
	}

	public void waitingForData() {
	}
	
	class ModelListener extends AdapterImpl {
		public void notifyChanged(Notification notification) {
			//PerfmonPlugin.DBG.info("NOTIFICATION RECEIVED "+notification);
			if(notification.getEventType() == Notification.ADD) {
				Object newValue = notification.getNewValue();

				boolean notify = false;
				SDDescriptor parent = null;

				if (newValue instanceof SDDescriptor) {
					notify = true;
					parent = ((SDDescriptor)newValue).getParent();

					((SDDescriptor)newValue).eAdapters().add(adapter);

				} else if (newValue instanceof SDSnapshotObservation) {
					notify = true;
					parent = ((SDSnapshotObservation)newValue).getMemberDescriptor();
				}				
				
				if (notify) {
					for (int i = 0; i < listeners.size(); i++) {
						StatisticalLoaderListener listener = (StatisticalLoaderListener)listeners.get(i);
						listener.modelChanged(parent);	
					}
				}
			}
		}	
	}
}
