/**********************************************************************
 * Copyright (c) 2003,2004,2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.perfmon.utils.internal.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.perfmon.ImageManager;
import org.eclipse.hyades.perfmon.PerfmonPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class HostTab extends AbstractLaunchConfigurationTab
{
    public static final String HOSTNAME = "ATTR_HOST";
    public static final String PORT = "ATTR_PORT";
    private String ATTR_HOSTNAME = "ATTR_HOST";
    private String ATTR_PORT = "ATTR_PORT";
    private int DEFAULT_PORT = 10002;
	private HostUI _ui;

	private String _oldHost;
	private int _oldPort = -1;
	private String agentname;

	public HostTab(String agentname)
	{
		super();		
	    this.agentname = agentname;
	    ATTR_HOSTNAME = HOSTNAME+agentname;
	    ATTR_PORT = PORT+agentname;
	}

	public void createControl(Composite parent)
	{
		parent.setLayout(new FillLayout());
		Composite content = new Composite(parent, SWT.NULL);		
		setControl(content);
		content.setLayout(new GridLayout());
		createVerticalSpacer(content, 1);

		_ui = new HostUI(agentname);
		_ui.createControl(content);
		_ui.addListener(new Listener()
		{
			public void handleEvent(Event event)
			{
				String host = _ui.getHost();
				int port = _ui.getPort();
				
				_oldHost = host;
				_oldPort = port;
			    setDirty(true);				

				// the host changed; update
				updateLaunchConfigurationDialog();				
				updatePreferences();
			}
		});
	}

	public boolean isValid(ILaunchConfiguration conf)
	{
		setErrorMessage(null);
		setMessage(null);

		if (_ui.getHost() == null)
		{
			setErrorMessage(PerfmonPlugin.getString("TAB_ERROR_HOST"));
			return false;
		}

		return true;
	}

	public void setDefaults(ILaunchConfigurationWorkingCopy wc)
	{
		IPreferenceStore store = PerfmonPlugin.getDefault().getPreferenceStore();
		wc.setAttribute(ATTR_HOSTNAME, "localhost");
		wc.setAttribute(ATTR_PORT, DEFAULT_PORT);
	}

	public void initializeFrom(ILaunchConfiguration conf)
	{
		IPreferenceStore store = PerfmonPlugin.getDefault().getPreferenceStore();

		try
		{
			String host = conf.getAttribute(ATTR_HOSTNAME, "localhost");
			int port = conf.getAttribute(ATTR_PORT, DEFAULT_PORT);
			String info = host + ":" + port;

			_ui.addHost(info);
			_ui.selectHost(info);
			_oldHost = host;
			_oldPort = port;
		}
		catch (CoreException e)
		{
			e.printStackTrace();
		}
	}

	public void performApply(ILaunchConfigurationWorkingCopy wc)
	{
		wc.setAttribute(ATTR_HOSTNAME, _ui.getHost());
		wc.setAttribute(ATTR_PORT, _ui.getPort());
	}

	public String getName()
	{
		return PerfmonPlugin.getString("TAB_NAME_HOST");
	}

	public Image getImage()
	{
		return PerfmonPlugin.img.getImage(ImageManager.IMG_LC_NODE);
	}
	
	public boolean isLocal()
	{
		return _ui.isLocalHost(_ui.getHost());
	}
	
	private void updatePreferences()
	{
		IPreferenceStore store = PerfmonPlugin.getDefault().getPreferenceStore();

		StringBuffer buf = new StringBuffer();
		
		TableItem[] items = _ui.getHosts();
		for(int idx=0; idx<items.length; idx++)	{
			buf.append(',');
			buf.append(items[idx].getText().trim());		
		}

		String hosts = buf.toString();
		if(hosts.startsWith(",") && hosts.length() > 1) {
			hosts = hosts.substring(1);
		}

		store.setValue(ATTR_HOSTNAME, hosts);
	}
}
