/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PDLabelProvider.java,v 1.7 2005/03/19 00:47:46 curtispd Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.internal.ui;

import java.util.*;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public abstract class PDLabelProvider extends LabelProvider
{
  private Map imageTable;
  
  private Image fMonitor =
	PDPluginImages.getImage(PDPluginImages.IMG_UI_MONITOR);
  private Image fNode =
	PDPluginImages.getImage(PDPluginImages.IMG_UI_NODE);
  private Image fProcess =
	PDPluginImages.getImage(PDPluginImages.IMG_UI_PROCESS);

  private Image fMonAgent =
	PDPluginImages.getImage(PDPluginImages.IMG_UI_MON_AGENT);
  private Image fRunAgent =
	PDPluginImages.getImage(PDPluginImages.IMG_UI_RUN_AGENT);
  private Image fStopAgent =
	PDPluginImages.getImage(PDPluginImages.IMG_UI_STOP_AGENT);

  private Image fDetachedAgent =
	PDPluginImages.getImage(PDPluginImages.IMG_UI_DETACHED_AGENT);  
	
/**
 * Disposes of all IWorkbenchAdapter based allocated images.
 */
public void dispose() {
	if (imageTable != null) {
		for (Iterator i = imageTable.values().iterator(); i.hasNext();) {
			((Image) i.next()).dispose();
		}
		imageTable = null;
	}
}

/**
 * Returns the image to display for the passed resource element.
 * NOTE: The resource label provider caches its images, so don't
 * dispose them!
 */
public Image getImage(Object element)
{
	if (element instanceof IAdaptable && 
		((IAdaptable)element).getAdapter(IWorkbenchAdapter.class) != null)
	{
		IWorkbenchAdapter adapter =
			(IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);

		//obtain the cached image corresponding to the descriptor
		if (imageTable == null) {
			 imageTable = new Hashtable(40);
		}
		ImageDescriptor descriptor = adapter.getImageDescriptor(element);		
		Image image = (Image) imageTable.get(descriptor);
		if (image == null) {
			image = descriptor.createImage();
			imageTable.put(descriptor, image);
		}
		return image;

	}
	else if(element instanceof TRCMonitor)
	  return fMonitor;
	else if(element instanceof TRCNode)
	  return fNode;
	else if(element instanceof TRCProcessProxy)
	  return fProcess;
	else if(element instanceof TRCAgentProxy)
	{
	  if(!((TRCAgentProxy)element).isActive())	  
		    return fStopAgent; //inactive
	  if(!((TRCAgentProxy)element).isAttached())
		    return fDetachedAgent; //detached		    
	  if(((TRCAgentProxy)element).isMonitored())
		    return fMonAgent; //monitored

	  return fRunAgent; //running and attached	    
		
	}
	else if(element instanceof INavigatorItem)
		return ((INavigatorItem)element).getImage();

	return null;
}

/**
 * Returns the process label to be displayed. This should be a human readable,
 * translated string that describes the process. Concrete implementations should
 * provide the process label as desired for their purposes.
 * 
 * @param process the process whose label to get.
 * @return the process's label to be displayed to the user.
 */
protected abstract String getProcessLabel(TRCProcessProxy process);

/* (non-Javadoc)
 * Method declared on ILabelProvider.
 */
public String getText(Object element)
{
	if (element instanceof IAdaptable && 
			((IAdaptable)element).getAdapter(IWorkbenchAdapter.class) != null)
	{
		IWorkbenchAdapter adapter =
			(IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);

		return adapter.getLabel(element);
	}
	else if(element instanceof TRCMonitor)
	  return ((TRCMonitor)element).getName();
	else if(element instanceof TRCNode)
	  return ((TRCNode)element).getName();//+":"+String.valueOf(((TRCNode)element).getPort());
	else if(element instanceof TRCProcessProxy)
	  return getProcessLabel((TRCProcessProxy)element);
	else if(element instanceof TRCAgentProxy)
	{
	  TRCAgentProxy a = (TRCAgentProxy)element;	  
	  String status = HyadesUtil.getAgentLabel(a);
	  
	  return status+" "+HyadesUtil.getAgentName(a);
	}
	else if(element instanceof INavigatorItem)
		return ((INavigatorItem)element).getText();
	  
	return "?";
}
}
