/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TraceSelection.java,v 1.4 2005/02/16 22:23:46 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.internal.ui;

import java.util.*;

import org.eclipse.hyades.trace.ui.ITraceSelection;

/**
 * A concrete implementation of the <code>IStructuredSelection</code> interface,
 * used to store trace views selections.
 * <p>
 * This class is not intended to be subclassed.
 * </p>
 */
public class TraceSelection implements ITraceSelection {
	/**
	 * The elements that make up this structured selection.
	 */
	private ArrayList elements = new ArrayList();

	public TraceSelection() {
	}
	
	/**
	 * 
	 * @param object
	 * @return true if the object is selected
	 */
	public boolean contains(Object object) {
		return elements.contains(object);
	}
	
	/* (non-Javadoc)
	 * Method declared in IStructuredSelection.
	 */
	public int size() {
		return elements == null ? 0 : elements.size();
	}
	
	/**
	 * Remove selection
	 */
	public void reset() {
		elements.clear();
	}
	
	/**
	 * 
	 * @param object new selection
	 */
	public void add(Object object)
	{
		if (object == null) {

			if (elements.size() == 0)
				return; // nothing selected

			elements.clear();
			return;
		}

		if (elements.size() == 1 && elements.get(0).equals(object))
			return; // same object reselected

		elements.clear();
		elements.add(object);
	}

	/* (non-Javadoc)
	 * Method declared in IStructuredSelection.
	 */
	public Object getFirstElement() {
		return isEmpty() ? null : elements.get(0);
	}

	/* (non-Javadoc)
	 * Method declared in ISelection.
	 */
	public boolean isEmpty() {
		return elements == null || elements.size() == 0;
	}

	/* (non-Javadoc)
	 * Method declared in IStructuredSelection.
	 */
	public Object[] toArray() {
		return elements == null ? new Object[0] : elements.toArray();
	}

	/* (non-Javadoc)
	 * Method declared in IStructuredSelection.
	 */
	public List toList() {
		return Arrays.asList(
			elements == null ? new Object[0] : elements.toArray());
	}

	/* (non-Javadoc)
	 * Method declared in IStructuredSelection.
	 */
	public Iterator iterator() {
		return Arrays
			.asList(elements == null ? new Object[0] : elements.toArray())
			.iterator();
	}

}
